// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.SdkDsl

public class VerifyMacRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * The KMS key that will be used in the verification.
     *
     * Enter a key ID of the KMS key that was used to generate the HMAC. If you identify a different KMS key, the `VerifyMac` operation fails.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The HMAC to verify. Enter the HMAC that was generated by the GenerateMac operation when you specified the same message, HMAC KMS key, and MAC algorithm as the values specified in this request.
     */
    public val mac: kotlin.ByteArray? = builder.mac
    /**
     * The MAC algorithm that will be used in the verification. Enter the same MAC algorithm that was used to compute the HMAC. This algorithm must be supported by the HMAC KMS key identified by the `KeyId` parameter.
     */
    public val macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = builder.macAlgorithm
    /**
     * The message that will be used in the verification. Enter the same message that was used to generate the HMAC.
     *
     * GenerateMac and `VerifyMac` do not provide special handling for message digests. If you generated an HMAC for a hash digest of a message, you must verify the HMAC for the same hash digest.
     */
    public val message: kotlin.ByteArray? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.VerifyMacRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyMacRequest(")
        append("dryRun=$dryRun,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("mac=$mac,")
        append("macAlgorithm=$macAlgorithm,")
        append("message=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (mac?.contentHashCode() ?: 0)
        result = 31 * result + (macAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyMacRequest

        if (dryRun != other.dryRun) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (mac != null) {
            if (other.mac == null) return false
            if (!mac.contentEquals(other.mac)) return false
        } else if (other.mac != null) return false
        if (macAlgorithm != other.macAlgorithm) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.VerifyMacRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * The KMS key that will be used in the verification.
         *
         * Enter a key ID of the KMS key that was used to generate the HMAC. If you identify a different KMS key, the `VerifyMac` operation fails.
         */
        public var keyId: kotlin.String? = null
        /**
         * The HMAC to verify. Enter the HMAC that was generated by the GenerateMac operation when you specified the same message, HMAC KMS key, and MAC algorithm as the values specified in this request.
         */
        public var mac: kotlin.ByteArray? = null
        /**
         * The MAC algorithm that will be used in the verification. Enter the same MAC algorithm that was used to compute the HMAC. This algorithm must be supported by the HMAC KMS key identified by the `KeyId` parameter.
         */
        public var macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = null
        /**
         * The message that will be used in the verification. Enter the same message that was used to generate the HMAC.
         *
         * GenerateMac and `VerifyMac` do not provide special handling for message digests. If you generated an HMAC for a hash digest of a message, you must verify the HMAC for the same hash digest.
         */
        public var message: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.VerifyMacRequest) : this() {
            this.dryRun = x.dryRun
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.mac = x.mac
            this.macAlgorithm = x.macAlgorithm
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.VerifyMacRequest = VerifyMacRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
