// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.ReEncryptResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64Bytes


internal class ReEncryptOperationDeserializer: HttpDeserializer.NonStreaming<ReEncryptResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ReEncryptResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwReEncryptError(context, call, payload)
        }
        val builder = ReEncryptResponse.Builder()

        if (payload != null) {
            deserializeReEncryptOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwReEncryptError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCiphertextException" -> InvalidCiphertextExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IncorrectKeyException" -> IncorrectKeyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeReEncryptOperationBody(builder: ReEncryptResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CIPHERTEXTBLOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("CiphertextBlob"))
    val DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DestinationEncryptionAlgorithm"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val SOURCEENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SourceEncryptionAlgorithm"))
    val SOURCEKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceKeyId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIPHERTEXTBLOB_DESCRIPTOR)
        field(DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(SOURCEENCRYPTIONALGORITHM_DESCRIPTOR)
        field(SOURCEKEYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CIPHERTEXTBLOB_DESCRIPTOR.index -> builder.ciphertextBlob = deserializeString().decodeBase64Bytes()
                DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR.index -> builder.destinationEncryptionAlgorithm = deserializeString().let { EncryptionAlgorithmSpec.fromValue(it) }
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                SOURCEENCRYPTIONALGORITHM_DESCRIPTOR.index -> builder.sourceEncryptionAlgorithm = deserializeString().let { EncryptionAlgorithmSpec.fromValue(it) }
                SOURCEKEYID_DESCRIPTOR.index -> builder.sourceKeyId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
