// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateCustomKeyStoreOperationDeserializer: HttpDeserialize<UpdateCustomKeyStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateCustomKeyStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateCustomKeyStoreError(context, call)
        }
        val builder = UpdateCustomKeyStoreResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateCustomKeyStoreError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "XksProxyIncorrectAuthenticationCredentialException" -> XksProxyIncorrectAuthenticationCredentialExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceInvalidConfigurationException" -> XksProxyVpcEndpointServiceInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreNameInUseException" -> CustomKeyStoreNameInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotFoundException" -> CloudHsmClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceInUseException" -> XksProxyVpcEndpointServiceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyInvalidResponseException" -> XksProxyInvalidResponseExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyInvalidConfigurationException" -> XksProxyInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriUnreachableException" -> XksProxyUriUnreachableExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotRelatedException" -> CloudHsmClusterNotRelatedExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriInUseException" -> XksProxyUriInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceNotFoundException" -> XksProxyVpcEndpointServiceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriEndpointInUseException" -> XksProxyUriEndpointInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotActiveException" -> CloudHsmClusterNotActiveExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreInvalidStateException" -> CustomKeyStoreInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreNotFoundException" -> CustomKeyStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
