// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.ConnectCustomKeyStoreResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ConnectCustomKeyStoreOperationDeserializer: HttpDeserialize<ConnectCustomKeyStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ConnectCustomKeyStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwConnectCustomKeyStoreError(context, call)
        }
        val builder = ConnectCustomKeyStoreResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwConnectCustomKeyStoreError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotActiveException" -> CloudHsmClusterNotActiveExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreInvalidStateException" -> CustomKeyStoreInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreNotFoundException" -> CustomKeyStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
