// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class VerifyResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key that was used to verify the signature.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * A Boolean value that indicates whether the signature was verified. A value of `True` indicates that the `Signature` was produced by signing the `Message` with the specified `KeyID` and `SigningAlgorithm.` If the signature is not verified, the `Verify` operation fails with a `KMSInvalidSignatureException` exception.
     */
    public val signatureValid: kotlin.Boolean = builder.signatureValid
    /**
     * The signing algorithm that was used to verify the signature.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.VerifyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyResponse(")
        append("keyId=$keyId,")
        append("signatureValid=$signatureValid,")
        append("signingAlgorithm=$signingAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (signatureValid.hashCode())
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyResponse

        if (keyId != other.keyId) return false
        if (signatureValid != other.signatureValid) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.VerifyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key that was used to verify the signature.
         */
        public var keyId: kotlin.String? = null
        /**
         * A Boolean value that indicates whether the signature was verified. A value of `True` indicates that the `Signature` was produced by signing the `Message` with the specified `KeyID` and `SigningAlgorithm.` If the signature is not verified, the `Verify` operation fails with a `KMSInvalidSignatureException` exception.
         */
        public var signatureValid: kotlin.Boolean = false
        /**
         * The signing algorithm that was used to verify the signature.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.VerifyResponse) : this() {
            this.keyId = x.keyId
            this.signatureValid = x.signatureValid
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.VerifyResponse = VerifyResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
