// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class UpdateCustomKeyStoreRequest private constructor(builder: Builder) {
    /**
     * Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
     *
     * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must [fulfill the requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore) for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
     *
     * To change this value, the CloudHSM key store must be disconnected.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * Enter the current password of the `kmsuser` crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
     *
     * This parameter tells KMS the current password of the `kmsuser` crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.
     *
     * To change this value, the CloudHSM key store must be disconnected.
     */
    public val keyStorePassword: kotlin.String? = builder.keyStorePassword
    /**
     * Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.
     */
    public val newCustomKeyStoreName: kotlin.String? = builder.newCustomKeyStoreName
    /**
     * Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * You must specify both the `AccessKeyId` and `SecretAccessKey` value in the authentication credential, even if you are only updating one value.
     *
     * This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.
     *
     * You can change this value when the external key store is connected or disconnected.
     */
    public val xksProxyAuthenticationCredential: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType? = builder.xksProxyAuthenticationCredential
    /**
     * Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify `VPC_ENDPOINT_SERVICE`. Otherwise, specify `PUBLIC_ENDPOINT`.
     *
     * If you change the `XksProxyConnectivity` to `VPC_ENDPOINT_SERVICE`, you must also change the `XksProxyUriEndpoint` and add an `XksProxyVpcEndpointServiceName` value.
     *
     * If you change the `XksProxyConnectivity` to `PUBLIC_ENDPOINT`, you must also change the `XksProxyUriEndpoint` and specify a null or empty string for the `XksProxyVpcEndpointServiceName` value.
     *
     * To change this value, the external key store must be disconnected.
     */
    public val xksProxyConnectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = builder.xksProxyConnectivity
    /**
     * Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * For external key stores with an `XksProxyConnectivity` value of `PUBLIC_ENDPOINT`, the protocol must be HTTPS.
     *
     * For external key stores with an `XksProxyConnectivity` value of `VPC_ENDPOINT_SERVICE`, specify `https://` followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.
     *
     * The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
     *
     * To change this value, the external key store must be disconnected.
     */
    public val xksProxyUriEndpoint: kotlin.String? = builder.xksProxyUriEndpoint
    /**
     * Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
     *
     * The value must start with `/` and must end with `/kms/xks/v1`, where `v1` represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as `/<i>example</i>/kms/xks/v1`.
     *
     * The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
     *
     * You can change this value when the external key store is connected or disconnected.
     */
    public val xksProxyUriPath: kotlin.String? = builder.xksProxyUriPath
    /**
     * Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the `CustomKeyStoreType` is `EXTERNAL_KEY_STORE` and the `XksProxyConnectivity` is `VPC_ENDPOINT_SERVICE`.
     *
     * To change this value, the external key store must be disconnected.
     */
    public val xksProxyVpcEndpointServiceName: kotlin.String? = builder.xksProxyVpcEndpointServiceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCustomKeyStoreRequest(")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("customKeyStoreId=$customKeyStoreId,")
        append("keyStorePassword=*** Sensitive Data Redacted ***,")
        append("newCustomKeyStoreName=$newCustomKeyStoreName,")
        append("xksProxyAuthenticationCredential=$xksProxyAuthenticationCredential,")
        append("xksProxyConnectivity=$xksProxyConnectivity,")
        append("xksProxyUriEndpoint=$xksProxyUriEndpoint,")
        append("xksProxyUriPath=$xksProxyUriPath,")
        append("xksProxyVpcEndpointServiceName=$xksProxyVpcEndpointServiceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudHsmClusterId?.hashCode() ?: 0
        result = 31 * result + (customKeyStoreId?.hashCode() ?: 0)
        result = 31 * result + (keyStorePassword?.hashCode() ?: 0)
        result = 31 * result + (newCustomKeyStoreName?.hashCode() ?: 0)
        result = 31 * result + (xksProxyAuthenticationCredential?.hashCode() ?: 0)
        result = 31 * result + (xksProxyConnectivity?.hashCode() ?: 0)
        result = 31 * result + (xksProxyUriEndpoint?.hashCode() ?: 0)
        result = 31 * result + (xksProxyUriPath?.hashCode() ?: 0)
        result = 31 * result + (xksProxyVpcEndpointServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCustomKeyStoreRequest

        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (customKeyStoreId != other.customKeyStoreId) return false
        if (keyStorePassword != other.keyStorePassword) return false
        if (newCustomKeyStoreName != other.newCustomKeyStoreName) return false
        if (xksProxyAuthenticationCredential != other.xksProxyAuthenticationCredential) return false
        if (xksProxyConnectivity != other.xksProxyConnectivity) return false
        if (xksProxyUriEndpoint != other.xksProxyUriEndpoint) return false
        if (xksProxyUriPath != other.xksProxyUriPath) return false
        if (xksProxyVpcEndpointServiceName != other.xksProxyVpcEndpointServiceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
         *
         * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must [fulfill the requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore) for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
         *
         * To change this value, the CloudHSM key store must be disconnected.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * Enter the current password of the `kmsuser` crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `AWS_CLOUDHSM`.
         *
         * This parameter tells KMS the current password of the `kmsuser` crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.
         *
         * To change this value, the CloudHSM key store must be disconnected.
         */
        public var keyStorePassword: kotlin.String? = null
        /**
         * Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.
         */
        public var newCustomKeyStoreName: kotlin.String? = null
        /**
         * Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * You must specify both the `AccessKeyId` and `SecretAccessKey` value in the authentication credential, even if you are only updating one value.
         *
         * This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.
         *
         * You can change this value when the external key store is connected or disconnected.
         */
        public var xksProxyAuthenticationCredential: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType? = null
        /**
         * Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify `VPC_ENDPOINT_SERVICE`. Otherwise, specify `PUBLIC_ENDPOINT`.
         *
         * If you change the `XksProxyConnectivity` to `VPC_ENDPOINT_SERVICE`, you must also change the `XksProxyUriEndpoint` and add an `XksProxyVpcEndpointServiceName` value.
         *
         * If you change the `XksProxyConnectivity` to `PUBLIC_ENDPOINT`, you must also change the `XksProxyUriEndpoint` and specify a null or empty string for the `XksProxyVpcEndpointServiceName` value.
         *
         * To change this value, the external key store must be disconnected.
         */
        public var xksProxyConnectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = null
        /**
         * Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * For external key stores with an `XksProxyConnectivity` value of `PUBLIC_ENDPOINT`, the protocol must be HTTPS.
         *
         * For external key stores with an `XksProxyConnectivity` value of `VPC_ENDPOINT_SERVICE`, specify `https://` followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.
         *
         * The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
         *
         * To change this value, the external key store must be disconnected.
         */
        public var xksProxyUriEndpoint: kotlin.String? = null
        /**
         * Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a `CustomKeyStoreType` of `EXTERNAL_KEY_STORE`.
         *
         * The value must start with `/` and must end with `/kms/xks/v1`, where `v1` represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as `/<i>example</i>/kms/xks/v1`.
         *
         * The combined `XksProxyUriEndpoint` and `XksProxyUriPath` values must be unique in the Amazon Web Services account and Region.
         *
         * You can change this value when the external key store is connected or disconnected.
         */
        public var xksProxyUriPath: kotlin.String? = null
        /**
         * Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the `CustomKeyStoreType` is `EXTERNAL_KEY_STORE` and the `XksProxyConnectivity` is `VPC_ENDPOINT_SERVICE`.
         *
         * To change this value, the external key store must be disconnected.
         */
        public var xksProxyVpcEndpointServiceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest) : this() {
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.customKeyStoreId = x.customKeyStoreId
            this.keyStorePassword = x.keyStorePassword
            this.newCustomKeyStoreName = x.newCustomKeyStoreName
            this.xksProxyAuthenticationCredential = x.xksProxyAuthenticationCredential
            this.xksProxyConnectivity = x.xksProxyConnectivity
            this.xksProxyUriEndpoint = x.xksProxyUriEndpoint
            this.xksProxyUriPath = x.xksProxyUriPath
            this.xksProxyVpcEndpointServiceName = x.xksProxyVpcEndpointServiceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = UpdateCustomKeyStoreRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType] inside the given [block]
         */
        public fun xksProxyAuthenticationCredential(block: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType.Builder.() -> kotlin.Unit) {
            this.xksProxyAuthenticationCredential = aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
