// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class PutKeyPolicyRequest private constructor(builder: Builder) {
    /**
     * Skips ("bypasses") the key policy lockout safety check. The default value is false.
     *
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     *
     * For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*.
     *
     * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent PutKeyPolicy request on the KMS key.
     */
    public val bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = builder.bypassPolicyLockoutSafetyCheck
    /**
     * Sets the key policy on the specified KMS key.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The key policy to attach to the KMS key.
     *
     * The key policy must meet the following criteria:
     * + The key policy must allow the calling principal to make a subsequent `PutKeyPolicy` request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*. (To omit this condition, set `BypassPolicyLockoutSafetyCheck` to true.)
     * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal, you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     * A key policy document can include only the following characters:
     * + Printable ASCII characters from the space character (`\u0020`) through the end of the ASCII character range.
     * + Printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`).
     * + The tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) special characters
     *
     * For information about key policies, see [Key policies in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Key Management Service Developer Guide*.For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The name of the key policy. The only valid value is `default`.
     */
    public val policyName: kotlin.String? = builder.policyName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.PutKeyPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutKeyPolicyRequest(")
        append("bypassPolicyLockoutSafetyCheck=$bypassPolicyLockoutSafetyCheck,")
        append("keyId=$keyId,")
        append("policy=$policy,")
        append("policyName=$policyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassPolicyLockoutSafetyCheck?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutKeyPolicyRequest

        if (bypassPolicyLockoutSafetyCheck != other.bypassPolicyLockoutSafetyCheck) return false
        if (keyId != other.keyId) return false
        if (policy != other.policy) return false
        if (policyName != other.policyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.PutKeyPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Skips ("bypasses") the key policy lockout safety check. The default value is false.
         *
         * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
         *
         * For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*.
         *
         * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent PutKeyPolicy request on the KMS key.
         */
        public var bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = null
        /**
         * Sets the key policy on the specified KMS key.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * The key policy to attach to the KMS key.
         *
         * The key policy must meet the following criteria:
         * + The key policy must allow the calling principal to make a subsequent `PutKeyPolicy` request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*. (To omit this condition, set `BypassPolicyLockoutSafetyCheck` to true.)
         * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal, you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the *Amazon Web Services Identity and Access Management User Guide*.
         *
         * A key policy document can include only the following characters:
         * + Printable ASCII characters from the space character (`\u0020`) through the end of the ASCII character range.
         * + Printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`).
         * + The tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) special characters
         *
         * For information about key policies, see [Key policies in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Key Management Service Developer Guide*.For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
         */
        public var policy: kotlin.String? = null
        /**
         * The name of the key policy. The only valid value is `default`.
         */
        public var policyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.PutKeyPolicyRequest) : this() {
            this.bypassPolicyLockoutSafetyCheck = x.bypassPolicyLockoutSafetyCheck
            this.keyId = x.keyId
            this.policy = x.policy
            this.policyName = x.policyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.PutKeyPolicyRequest = PutKeyPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
