// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetParametersForImportResponse private constructor(builder: Builder) {
    /**
     * The import token to send in a subsequent ImportKeyMaterial request.
     */
    public val importToken: kotlin.ByteArray? = builder.importToken
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key to use in a subsequent ImportKeyMaterial request. This is the same KMS key specified in the `GetParametersForImport` request.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an ImportKeyMaterial request and you must send another `GetParametersForImport` request to get new ones.
     */
    public val parametersValidTo: aws.smithy.kotlin.runtime.time.Instant? = builder.parametersValidTo
    /**
     * The public key to use to encrypt the key material before importing it with ImportKeyMaterial.
     */
    public val publicKey: kotlin.ByteArray? = builder.publicKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GetParametersForImportResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetParametersForImportResponse(")
        append("importToken=$importToken,")
        append("keyId=$keyId,")
        append("parametersValidTo=$parametersValidTo,")
        append("publicKey=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = importToken?.contentHashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (parametersValidTo?.hashCode() ?: 0)
        result = 31 * result + (publicKey?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetParametersForImportResponse

        if (importToken != null) {
            if (other.importToken == null) return false
            if (!importToken.contentEquals(other.importToken)) return false
        } else if (other.importToken != null) return false
        if (keyId != other.keyId) return false
        if (parametersValidTo != other.parametersValidTo) return false
        if (publicKey != null) {
            if (other.publicKey == null) return false
            if (!publicKey.contentEquals(other.publicKey)) return false
        } else if (other.publicKey != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GetParametersForImportResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The import token to send in a subsequent ImportKeyMaterial request.
         */
        public var importToken: kotlin.ByteArray? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key to use in a subsequent ImportKeyMaterial request. This is the same KMS key specified in the `GetParametersForImport` request.
         */
        public var keyId: kotlin.String? = null
        /**
         * The time at which the import token and public key are no longer valid. After this time, you cannot use them to make an ImportKeyMaterial request and you must send another `GetParametersForImport` request to get new ones.
         */
        public var parametersValidTo: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The public key to use to encrypt the key material before importing it with ImportKeyMaterial.
         */
        public var publicKey: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GetParametersForImportResponse) : this() {
            this.importToken = x.importToken
            this.keyId = x.keyId
            this.parametersValidTo = x.parametersValidTo
            this.publicKey = x.publicKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GetParametersForImportResponse = GetParametersForImportResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
