// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateMacResponse private constructor(builder: Builder) {
    /**
     * The HMAC KMS key used in the operation.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The hash-based message authentication code (HMAC) that was generated for the specified message, HMAC KMS key, and MAC algorithm.
     *
     * This is the standard, raw HMAC defined in [RFC 2104](https://datatracker.ietf.org/doc/html/rfc2104).
     */
    public val mac: kotlin.ByteArray? = builder.mac
    /**
     * The MAC algorithm that was used to generate the HMAC.
     */
    public val macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = builder.macAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateMacResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateMacResponse(")
        append("keyId=$keyId,")
        append("mac=$mac,")
        append("macAlgorithm=$macAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (mac?.contentHashCode() ?: 0)
        result = 31 * result + (macAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateMacResponse

        if (keyId != other.keyId) return false
        if (mac != null) {
            if (other.mac == null) return false
            if (!mac.contentEquals(other.mac)) return false
        } else if (other.mac != null) return false
        if (macAlgorithm != other.macAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateMacResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The HMAC KMS key used in the operation.
         */
        public var keyId: kotlin.String? = null
        /**
         * The hash-based message authentication code (HMAC) that was generated for the specified message, HMAC KMS key, and MAC algorithm.
         *
         * This is the standard, raw HMAC defined in [RFC 2104](https://datatracker.ietf.org/doc/html/rfc2104).
         */
        public var mac: kotlin.ByteArray? = null
        /**
         * The MAC algorithm that was used to generate the HMAC.
         */
        public var macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateMacResponse) : this() {
            this.keyId = x.keyId
            this.mac = x.mac
            this.macAlgorithm = x.macAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateMacResponse = GenerateMacResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
