// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateMacRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * The HMAC KMS key to use in the operation. The MAC algorithm computes the HMAC for the message and the key as described in [RFC 2104](https://datatracker.ietf.org/doc/html/rfc2104).
     *
     * To identify an HMAC KMS key, use the DescribeKey operation and see the `KeySpec` field in the response.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The MAC algorithm used in the operation.
     *
     *  The algorithm must be compatible with the HMAC KMS key that you specify. To find the MAC algorithms that your HMAC KMS key supports, use the DescribeKey operation and see the `MacAlgorithms` field in the `DescribeKey` response.
     */
    public val macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = builder.macAlgorithm
    /**
     * The message to be hashed. Specify a message of up to 4,096 bytes.
     *
     * `GenerateMac` and VerifyMac do not provide special handling for message digests. If you generate an HMAC for a hash digest of a message, you must verify the HMAC of the same hash digest.
     */
    public val message: kotlin.ByteArray? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateMacRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateMacRequest(")
        append("dryRun=$dryRun,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("macAlgorithm=$macAlgorithm,")
        append("message=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (macAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateMacRequest

        if (dryRun != other.dryRun) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (macAlgorithm != other.macAlgorithm) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateMacRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * The HMAC KMS key to use in the operation. The MAC algorithm computes the HMAC for the message and the key as described in [RFC 2104](https://datatracker.ietf.org/doc/html/rfc2104).
         *
         * To identify an HMAC KMS key, use the DescribeKey operation and see the `KeySpec` field in the response.
         */
        public var keyId: kotlin.String? = null
        /**
         * The MAC algorithm used in the operation.
         *
         *  The algorithm must be compatible with the HMAC KMS key that you specify. To find the MAC algorithms that your HMAC KMS key supports, use the DescribeKey operation and see the `MacAlgorithms` field in the `DescribeKey` response.
         */
        public var macAlgorithm: aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec? = null
        /**
         * The message to be hashed. Specify a message of up to 4,096 bytes.
         *
         * `GenerateMac` and VerifyMac do not provide special handling for message digests. If you generate an HMAC for a hash digest of a message, you must verify the HMAC of the same hash digest.
         */
        public var message: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateMacRequest) : this() {
            this.dryRun = x.dryRun
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.macAlgorithm = x.macAlgorithm
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateMacRequest = GenerateMacRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
