// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.AliasListEntry
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.ListAliasesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListAliasesOperationDeserializer: HttpDeserialize<ListAliasesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListAliasesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAliasesError(context, call)
        }
        val builder = ListAliasesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAliasesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListAliasesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMarkerException" -> InvalidMarkerExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAliasesOperationBody(builder: ListAliasesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIASES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Aliases"))
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val TRUNCATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Truncated"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIASES_DESCRIPTOR)
        field(NEXTMARKER_DESCRIPTOR)
        field(TRUNCATED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIASES_DESCRIPTOR.index -> builder.aliases =
                    deserializer.deserializeList(ALIASES_DESCRIPTOR) {
                        val col0 = mutableListOf<AliasListEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAliasListEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                TRUNCATED_DESCRIPTOR.index -> builder.truncated = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
