// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



/**
 * Describes the configuration of this multi-Region key. This field appears only when the KMS key is a primary or replica of a multi-Region key.
 *
 * For more information about any listed KMS key, use the DescribeKey operation.
 */
public class MultiRegionConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
     */
    public val multiRegionKeyType: aws.sdk.kotlin.services.kms.model.MultiRegionKeyType? = builder.multiRegionKeyType
    /**
     * Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.
     */
    public val primaryKey: aws.sdk.kotlin.services.kms.model.MultiRegionKey? = builder.primaryKey
    /**
     * displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.
     */
    public val replicaKeys: List<MultiRegionKey>? = builder.replicaKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MultiRegionConfiguration(")
        append("multiRegionKeyType=$multiRegionKeyType,")
        append("primaryKey=$primaryKey,")
        append("replicaKeys=$replicaKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = multiRegionKeyType?.hashCode() ?: 0
        result = 31 * result + (primaryKey?.hashCode() ?: 0)
        result = 31 * result + (replicaKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MultiRegionConfiguration

        if (multiRegionKeyType != other.multiRegionKeyType) return false
        if (primaryKey != other.primaryKey) return false
        if (replicaKeys != other.replicaKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
         */
        public var multiRegionKeyType: aws.sdk.kotlin.services.kms.model.MultiRegionKeyType? = null
        /**
         * Displays the key ARN and Region of the primary key. This field includes the current KMS key if it is the primary key.
         */
        public var primaryKey: aws.sdk.kotlin.services.kms.model.MultiRegionKey? = null
        /**
         * displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.
         */
        public var replicaKeys: List<MultiRegionKey>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration) : this() {
            this.multiRegionKeyType = x.multiRegionKeyType
            this.primaryKey = x.primaryKey
            this.replicaKeys = x.replicaKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration = MultiRegionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.MultiRegionKey] inside the given [block]
         */
        public fun primaryKey(block: aws.sdk.kotlin.services.kms.model.MultiRegionKey.Builder.() -> kotlin.Unit) {
            this.primaryKey = aws.sdk.kotlin.services.kms.model.MultiRegionKey.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
