// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.GetParametersForImportResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64Bytes
import aws.smithy.kotlin.runtime.time.Instant


internal class GetParametersForImportOperationDeserializer: HttpDeserialize<GetParametersForImportResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetParametersForImportResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetParametersForImportError(context, call)
        }
        val builder = GetParametersForImportResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetParametersForImportOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetParametersForImportError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetParametersForImportOperationBody(builder: GetParametersForImportResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMPORTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("ImportToken"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val PARAMETERSVALIDTO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ParametersValidTo"))
    val PUBLICKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("PublicKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMPORTTOKEN_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(PARAMETERSVALIDTO_DESCRIPTOR)
        field(PUBLICKEY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMPORTTOKEN_DESCRIPTOR.index -> builder.importToken = deserializeString().decodeBase64Bytes()
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                PARAMETERSVALIDTO_DESCRIPTOR.index -> builder.parametersValidTo = deserializeString().let { Instant.fromEpochSeconds(it) }
                PUBLICKEY_DESCRIPTOR.index -> builder.publicKey = deserializeString().decodeBase64Bytes()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
