// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.CreateKeyResponse
import aws.sdk.kotlin.services.kms.model.KeyMetadata
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateKeyOperationDeserializer: HttpDeserialize<CreateKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateKeyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateKeyError(context, call)
        }
        val builder = CreateKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateKeyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateKeyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "MalformedPolicyDocumentException" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall)
        "TagException" -> TagExceptionDeserializer().deserialize(context, wrappedCall)
        "XksKeyNotFoundException" -> XksKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "XksKeyAlreadyInUseException" -> XksKeyAlreadyInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedCall)
        "XksKeyInvalidConfigurationException" -> XksKeyInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreInvalidStateException" -> CustomKeyStoreInvalidStateExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreNotFoundException" -> CustomKeyStoreNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateKeyOperationBody(builder: CreateKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("KeyMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYMETADATA_DESCRIPTOR.index -> builder.keyMetadata = deserializeKeyMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
