// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.serde

import aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomKeyStoreOperationDeserializer: HttpDeserialize<CreateCustomKeyStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateCustomKeyStoreResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCustomKeyStoreError(context, call)
        }
        val builder = CreateCustomKeyStoreResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCustomKeyStoreOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateCustomKeyStoreError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyIncorrectAuthenticationCredentialException" -> XksProxyIncorrectAuthenticationCredentialExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceInvalidConfigurationException" -> XksProxyVpcEndpointServiceInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomKeyStoreNameInUseException" -> CustomKeyStoreNameInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterInUseException" -> CloudHsmClusterInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotFoundException" -> CloudHsmClusterNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceInUseException" -> XksProxyVpcEndpointServiceInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "IncorrectTrustAnchorException" -> IncorrectTrustAnchorExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyInvalidResponseException" -> XksProxyInvalidResponseExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyInvalidConfigurationException" -> XksProxyInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriUnreachableException" -> XksProxyUriUnreachableExceptionDeserializer().deserialize(context, wrappedCall)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriInUseException" -> XksProxyUriInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyVpcEndpointServiceNotFoundException" -> XksProxyVpcEndpointServiceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "XksProxyUriEndpointInUseException" -> XksProxyUriEndpointInUseExceptionDeserializer().deserialize(context, wrappedCall)
        "CloudHsmClusterNotActiveException" -> CloudHsmClusterNotActiveExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCustomKeyStoreOperationBody(builder: CreateCustomKeyStoreResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMKEYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomKeyStoreId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMKEYSTOREID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMKEYSTOREID_DESCRIPTOR.index -> builder.customKeyStoreId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
