// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



/**
 * KMS uses the authentication credential to sign requests that it sends to the external key store proxy (XKS proxy) on your behalf. You establish these credentials on your external key store proxy and report them to KMS.
 *
 * The `XksProxyAuthenticationCredential` includes two required elements.
 */
public class XksProxyAuthenticationCredentialType private constructor(builder: Builder) {
    /**
     * A unique identifier for the raw secret access key.
     */
    public val accessKeyId: kotlin.String = requireNotNull(builder.accessKeyId) { "A non-null value must be provided for accessKeyId" }
    /**
     * A secret string of 43-64 characters. Valid characters are a-z, A-Z, 0-9, /, +, and =.
     */
    public val rawSecretAccessKey: kotlin.String = requireNotNull(builder.rawSecretAccessKey) { "A non-null value must be provided for rawSecretAccessKey" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XksProxyAuthenticationCredentialType(")
        append("accessKeyId=*** Sensitive Data Redacted ***,")
        append("rawSecretAccessKey=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId.hashCode()
        result = 31 * result + (rawSecretAccessKey.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XksProxyAuthenticationCredentialType

        if (accessKeyId != other.accessKeyId) return false
        if (rawSecretAccessKey != other.rawSecretAccessKey) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the raw secret access key.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * A secret string of 43-64 characters. Valid characters are a-z, A-Z, 0-9, /, +, and =.
         */
        public var rawSecretAccessKey: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType) : this() {
            this.accessKeyId = x.accessKeyId
            this.rawSecretAccessKey = x.rawSecretAccessKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.XksProxyAuthenticationCredentialType = XksProxyAuthenticationCredentialType(this)

        internal fun correctErrors(): Builder {
            if (accessKeyId == null) accessKeyId = ""
            if (rawSecretAccessKey == null) rawSecretAccessKey = ""
            return this
        }
    }
}
