// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ReEncryptResponse private constructor(builder: Builder) {
    /**
     * The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val ciphertextBlob: kotlin.ByteArray? = builder.ciphertextBlob
    /**
     * The encryption algorithm that was used to reencrypt the data.
     */
    public val destinationEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.destinationEncryptionAlgorithm
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to reencrypt the data.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The encryption algorithm that was used to decrypt the ciphertext before it was reencrypted.
     */
    public val sourceEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.sourceEncryptionAlgorithm
    /**
     * Unique identifier of the KMS key used to originally encrypt the data.
     */
    public val sourceKeyId: kotlin.String? = builder.sourceKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ReEncryptResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReEncryptResponse(")
        append("ciphertextBlob=$ciphertextBlob,")
        append("destinationEncryptionAlgorithm=$destinationEncryptionAlgorithm,")
        append("keyId=$keyId,")
        append("sourceEncryptionAlgorithm=$sourceEncryptionAlgorithm,")
        append("sourceKeyId=$sourceKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextBlob?.contentHashCode() ?: 0
        result = 31 * result + (destinationEncryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (sourceEncryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReEncryptResponse

        if (ciphertextBlob != null) {
            if (other.ciphertextBlob == null) return false
            if (!ciphertextBlob.contentEquals(other.ciphertextBlob)) return false
        } else if (other.ciphertextBlob != null) return false
        if (destinationEncryptionAlgorithm != other.destinationEncryptionAlgorithm) return false
        if (keyId != other.keyId) return false
        if (sourceEncryptionAlgorithm != other.sourceEncryptionAlgorithm) return false
        if (sourceKeyId != other.sourceKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ReEncryptResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var ciphertextBlob: kotlin.ByteArray? = null
        /**
         * The encryption algorithm that was used to reencrypt the data.
         */
        public var destinationEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to reencrypt the data.
         */
        public var keyId: kotlin.String? = null
        /**
         * The encryption algorithm that was used to decrypt the ciphertext before it was reencrypted.
         */
        public var sourceEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * Unique identifier of the KMS key used to originally encrypt the data.
         */
        public var sourceKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ReEncryptResponse) : this() {
            this.ciphertextBlob = x.ciphertextBlob
            this.destinationEncryptionAlgorithm = x.destinationEncryptionAlgorithm
            this.keyId = x.keyId
            this.sourceEncryptionAlgorithm = x.sourceEncryptionAlgorithm
            this.sourceKeyId = x.sourceKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ReEncryptResponse = ReEncryptResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
