// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateDataKeyResponse private constructor(builder: Builder) {
    /**
     * The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val ciphertextBlob: kotlin.ByteArray? = builder.ciphertextBlob
    /**
     * The plaintext data key encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
     *
     * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val ciphertextForRecipient: kotlin.ByteArray? = builder.ciphertextForRecipient
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that encrypted the data key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of KMS. Then, remove it from memory as soon as possible.
     *
     * If the response includes the `CiphertextForRecipient` field, the `Plaintext` field is null or empty.
     */
    public val plaintext: kotlin.ByteArray? = builder.plaintext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateDataKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateDataKeyResponse(")
        append("ciphertextBlob=$ciphertextBlob,")
        append("ciphertextForRecipient=$ciphertextForRecipient,")
        append("keyId=$keyId,")
        append("plaintext=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextBlob?.contentHashCode() ?: 0
        result = 31 * result + (ciphertextForRecipient?.contentHashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (plaintext?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateDataKeyResponse

        if (ciphertextBlob != null) {
            if (other.ciphertextBlob == null) return false
            if (!ciphertextBlob.contentEquals(other.ciphertextBlob)) return false
        } else if (other.ciphertextBlob != null) return false
        if (ciphertextForRecipient != null) {
            if (other.ciphertextForRecipient == null) return false
            if (!ciphertextForRecipient.contentEquals(other.ciphertextForRecipient)) return false
        } else if (other.ciphertextForRecipient != null) return false
        if (keyId != other.keyId) return false
        if (plaintext != null) {
            if (other.plaintext == null) return false
            if (!plaintext.contentEquals(other.plaintext)) return false
        } else if (other.plaintext != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateDataKeyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encrypted copy of the data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var ciphertextBlob: kotlin.ByteArray? = null
        /**
         * The plaintext data key encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
         *
         * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var ciphertextForRecipient: kotlin.ByteArray? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that encrypted the data key.
         */
        public var keyId: kotlin.String? = null
        /**
         * The plaintext data key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded. Use this data key to encrypt your data outside of KMS. Then, remove it from memory as soon as possible.
         *
         * If the response includes the `CiphertextForRecipient` field, the `Plaintext` field is null or empty.
         */
        public var plaintext: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateDataKeyResponse) : this() {
            this.ciphertextBlob = x.ciphertextBlob
            this.ciphertextForRecipient = x.ciphertextForRecipient
            this.keyId = x.keyId
            this.plaintext = x.plaintext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateDataKeyResponse = GenerateDataKeyResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
