// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateDataKeyRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specifies the encryption context that will be used when encrypting the data key.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
     *
     * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
     */
    public val encryptionContext: Map<String, String>? = builder.encryptionContext
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Specifies the symmetric encryption KMS key that encrypts the data key. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the DescribeKey operation.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Specifies the length of the data key. Use `AES_128` to generate a 128-bit symmetric key, or `AES_256` to generate a 256-bit symmetric key.
     *
     * You must specify either the `KeySpec` or the `NumberOfBytes` parameter (but not both) in every `GenerateDataKey` request.
     */
    public val keySpec: aws.sdk.kotlin.services.kms.model.DataKeySpec? = builder.keySpec
    /**
     * Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the `KeySpec` parameter.
     *
     * You must specify either the `KeySpec` or the `NumberOfBytes` parameter (but not both) in every `GenerateDataKey` request.
     */
    public val numberOfBytes: kotlin.Int? = builder.numberOfBytes
    /**
     * A signed [attestation document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
     *
     * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
     *
     * When you use this parameter, instead of returning the plaintext data key, KMS encrypts the plaintext data key under the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `CiphertextBlob` field in the response contains a copy of the data key encrypted under the KMS key specified by the `KeyId` parameter. The `Plaintext` field in the response is null or empty.
     *
     * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = builder.recipient

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateDataKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateDataKeyRequest(")
        append("dryRun=$dryRun,")
        append("encryptionContext=$encryptionContext,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("keySpec=$keySpec,")
        append("numberOfBytes=$numberOfBytes,")
        append("recipient=$recipient")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (encryptionContext?.hashCode() ?: 0)
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keySpec?.hashCode() ?: 0)
        result = 31 * result + (numberOfBytes ?: 0)
        result = 31 * result + (recipient?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateDataKeyRequest

        if (dryRun != other.dryRun) return false
        if (encryptionContext != other.encryptionContext) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (keySpec != other.keySpec) return false
        if (numberOfBytes != other.numberOfBytes) return false
        if (recipient != other.recipient) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateDataKeyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * Specifies the encryption context that will be used when encrypting the data key.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
         *
         * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
         */
        public var encryptionContext: Map<String, String>? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Specifies the symmetric encryption KMS key that encrypts the data key. You cannot specify an asymmetric KMS key or a KMS key in a custom key store. To get the type and origin of your KMS key, use the DescribeKey operation.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Specifies the length of the data key. Use `AES_128` to generate a 128-bit symmetric key, or `AES_256` to generate a 256-bit symmetric key.
         *
         * You must specify either the `KeySpec` or the `NumberOfBytes` parameter (but not both) in every `GenerateDataKey` request.
         */
        public var keySpec: aws.sdk.kotlin.services.kms.model.DataKeySpec? = null
        /**
         * Specifies the length of the data key in bytes. For example, use the value 64 to generate a 512-bit data key (64 bytes is 512 bits). For 128-bit (16-byte) and 256-bit (32-byte) data keys, use the `KeySpec` parameter.
         *
         * You must specify either the `KeySpec` or the `NumberOfBytes` parameter (but not both) in every `GenerateDataKey` request.
         */
        public var numberOfBytes: kotlin.Int? = null
        /**
         * A signed [attestation document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
         *
         * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
         *
         * When you use this parameter, instead of returning the plaintext data key, KMS encrypts the plaintext data key under the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `CiphertextBlob` field in the response contains a copy of the data key encrypted under the KMS key specified by the `KeyId` parameter. The `Plaintext` field in the response is null or empty.
         *
         * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateDataKeyRequest) : this() {
            this.dryRun = x.dryRun
            this.encryptionContext = x.encryptionContext
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.keySpec = x.keySpec
            this.numberOfBytes = x.numberOfBytes
            this.recipient = x.recipient
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateDataKeyRequest = GenerateDataKeyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.RecipientInfo] inside the given [block]
         */
        public fun recipient(block: aws.sdk.kotlin.services.kms.model.RecipientInfo.Builder.() -> kotlin.Unit) {
            this.recipient = aws.sdk.kotlin.services.kms.model.RecipientInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
