// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateDataKeyPairResponse private constructor(builder: Builder) {
    /**
     * The plaintext private data key encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
     *
     * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val ciphertextForRecipient: kotlin.ByteArray? = builder.ciphertextForRecipient
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that encrypted the private key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The type of data key pair that was generated.
     */
    public val keyPairSpec: aws.sdk.kotlin.services.kms.model.DataKeyPairSpec? = builder.keyPairSpec
    /**
     * The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val privateKeyCiphertextBlob: kotlin.ByteArray? = builder.privateKeyCiphertextBlob
    /**
     * The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     *
     * If the response includes the `CiphertextForRecipient` field, the `PrivateKeyPlaintext` field is null or empty.
     */
    public val privateKeyPlaintext: kotlin.ByteArray? = builder.privateKeyPlaintext
    /**
     * The public key (in plaintext). When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val publicKey: kotlin.ByteArray? = builder.publicKey

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateDataKeyPairResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateDataKeyPairResponse(")
        append("ciphertextForRecipient=$ciphertextForRecipient,")
        append("keyId=$keyId,")
        append("keyPairSpec=$keyPairSpec,")
        append("privateKeyCiphertextBlob=$privateKeyCiphertextBlob,")
        append("privateKeyPlaintext=*** Sensitive Data Redacted ***,")
        append("publicKey=$publicKey")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextForRecipient?.contentHashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyPairSpec?.hashCode() ?: 0)
        result = 31 * result + (privateKeyCiphertextBlob?.contentHashCode() ?: 0)
        result = 31 * result + (privateKeyPlaintext?.contentHashCode() ?: 0)
        result = 31 * result + (publicKey?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateDataKeyPairResponse

        if (ciphertextForRecipient != null) {
            if (other.ciphertextForRecipient == null) return false
            if (!ciphertextForRecipient.contentEquals(other.ciphertextForRecipient)) return false
        } else if (other.ciphertextForRecipient != null) return false
        if (keyId != other.keyId) return false
        if (keyPairSpec != other.keyPairSpec) return false
        if (privateKeyCiphertextBlob != null) {
            if (other.privateKeyCiphertextBlob == null) return false
            if (!privateKeyCiphertextBlob.contentEquals(other.privateKeyCiphertextBlob)) return false
        } else if (other.privateKeyCiphertextBlob != null) return false
        if (privateKeyPlaintext != null) {
            if (other.privateKeyPlaintext == null) return false
            if (!privateKeyPlaintext.contentEquals(other.privateKeyPlaintext)) return false
        } else if (other.privateKeyPlaintext != null) return false
        if (publicKey != null) {
            if (other.publicKey == null) return false
            if (!publicKey.contentEquals(other.publicKey)) return false
        } else if (other.publicKey != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateDataKeyPairResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The plaintext private data key encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
         *
         * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var ciphertextForRecipient: kotlin.ByteArray? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that encrypted the private key.
         */
        public var keyId: kotlin.String? = null
        /**
         * The type of data key pair that was generated.
         */
        public var keyPairSpec: aws.sdk.kotlin.services.kms.model.DataKeyPairSpec? = null
        /**
         * The encrypted copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var privateKeyCiphertextBlob: kotlin.ByteArray? = null
        /**
         * The plaintext copy of the private key. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         *
         * If the response includes the `CiphertextForRecipient` field, the `PrivateKeyPlaintext` field is null or empty.
         */
        public var privateKeyPlaintext: kotlin.ByteArray? = null
        /**
         * The public key (in plaintext). When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var publicKey: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateDataKeyPairResponse) : this() {
            this.ciphertextForRecipient = x.ciphertextForRecipient
            this.keyId = x.keyId
            this.keyPairSpec = x.keyPairSpec
            this.privateKeyCiphertextBlob = x.privateKeyCiphertextBlob
            this.privateKeyPlaintext = x.privateKeyPlaintext
            this.publicKey = x.publicKey
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateDataKeyPairResponse = GenerateDataKeyPairResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
