// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ReEncryptRequest private constructor(builder: Builder) {
    /**
     * Ciphertext of the data to reencrypt.
     */
    public val ciphertextBlob: kotlin.ByteArray? = builder.ciphertextBlob
    /**
     * Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, `SYMMETRIC_DEFAULT`, represents the encryption algorithm used for symmetric encryption KMS keys.
     *
     * This parameter is required only when the destination KMS key is an asymmetric KMS key.
     */
    public val destinationEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.destinationEncryptionAlgorithm
    /**
     * Specifies that encryption context to use when the reencrypting the data.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * A destination encryption context is valid only when the destination KMS key is a symmetric encryption KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.
     *
     * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
     *
     * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
     */
    public val destinationEncryptionContext: Map<String, String>? = builder.destinationEncryptionContext
    /**
     * A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric encryption KMS key or an asymmetric KMS key with a `KeyUsage` value of `ENCRYPT_DECRYPT`. To find the `KeyUsage` value of a KMS key, use the DescribeKey operation.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val destinationKeyId: kotlin.String? = builder.destinationKeyId
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, `SYMMETRIC_DEFAULT`, represents the algorithm used for symmetric encryption KMS keys.
     *
     * Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.
     *
     * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
     */
    public val sourceEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.sourceEncryptionAlgorithm
    /**
     * Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.
     *
     * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
     *
     * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
     */
    public val sourceEncryptionContext: Map<String, String>? = builder.sourceEncryptionContext
    /**
     * Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted.
     *
     * Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the `ReEncrypt` operation throws an `IncorrectKeyException`.
     *
     * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val sourceKeyId: kotlin.String? = builder.sourceKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ReEncryptRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReEncryptRequest(")
        append("ciphertextBlob=$ciphertextBlob,")
        append("destinationEncryptionAlgorithm=$destinationEncryptionAlgorithm,")
        append("destinationEncryptionContext=$destinationEncryptionContext,")
        append("destinationKeyId=$destinationKeyId,")
        append("dryRun=$dryRun,")
        append("grantTokens=$grantTokens,")
        append("sourceEncryptionAlgorithm=$sourceEncryptionAlgorithm,")
        append("sourceEncryptionContext=$sourceEncryptionContext,")
        append("sourceKeyId=$sourceKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextBlob?.contentHashCode() ?: 0
        result = 31 * result + (destinationEncryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (destinationEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (destinationKeyId?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (sourceEncryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (sourceEncryptionContext?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReEncryptRequest

        if (ciphertextBlob != null) {
            if (other.ciphertextBlob == null) return false
            if (!ciphertextBlob.contentEquals(other.ciphertextBlob)) return false
        } else if (other.ciphertextBlob != null) return false
        if (destinationEncryptionAlgorithm != other.destinationEncryptionAlgorithm) return false
        if (destinationEncryptionContext != other.destinationEncryptionContext) return false
        if (destinationKeyId != other.destinationKeyId) return false
        if (dryRun != other.dryRun) return false
        if (grantTokens != other.grantTokens) return false
        if (sourceEncryptionAlgorithm != other.sourceEncryptionAlgorithm) return false
        if (sourceEncryptionContext != other.sourceEncryptionContext) return false
        if (sourceKeyId != other.sourceKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ReEncryptRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Ciphertext of the data to reencrypt.
         */
        public var ciphertextBlob: kotlin.ByteArray? = null
        /**
         * Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, `SYMMETRIC_DEFAULT`, represents the encryption algorithm used for symmetric encryption KMS keys.
         *
         * This parameter is required only when the destination KMS key is an asymmetric KMS key.
         */
        public var destinationEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * Specifies that encryption context to use when the reencrypting the data.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * A destination encryption context is valid only when the destination KMS key is a symmetric encryption KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.
         *
         * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
         *
         * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
         */
        public var destinationEncryptionContext: Map<String, String>? = null
        /**
         * A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric encryption KMS key or an asymmetric KMS key with a `KeyUsage` value of `ENCRYPT_DECRYPT`. To find the `KeyUsage` value of a KMS key, use the DescribeKey operation.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var destinationKeyId: kotlin.String? = null
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, `SYMMETRIC_DEFAULT`, represents the algorithm used for symmetric encryption KMS keys.
         *
         * Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.
         *
         * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.
         */
        public var sourceEncryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.
         *
         * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
         *
         * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
         */
        public var sourceEncryptionContext: Map<String, String>? = null
        /**
         * Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted.
         *
         * Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the `ReEncrypt` operation throws an `IncorrectKeyException`.
         *
         * This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var sourceKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ReEncryptRequest) : this() {
            this.ciphertextBlob = x.ciphertextBlob
            this.destinationEncryptionAlgorithm = x.destinationEncryptionAlgorithm
            this.destinationEncryptionContext = x.destinationEncryptionContext
            this.destinationKeyId = x.destinationKeyId
            this.dryRun = x.dryRun
            this.grantTokens = x.grantTokens
            this.sourceEncryptionAlgorithm = x.sourceEncryptionAlgorithm
            this.sourceEncryptionContext = x.sourceEncryptionContext
            this.sourceKeyId = x.sourceKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ReEncryptRequest = ReEncryptRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
