// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.time.Instant

public class ImportKeyMaterialRequest private constructor(builder: Builder) {
    /**
     * The encrypted key material to import. The key material must be encrypted under the public wrapping key that GetParametersForImport returned, using the wrapping algorithm that you specified in the same `GetParametersForImport` request.
     */
    public val encryptedKeyMaterial: kotlin.ByteArray? = builder.encryptedKeyMaterial
    /**
     * Specifies whether the key material expires. The default is `KEY_MATERIAL_EXPIRES`. For help with this choice, see [Setting an expiration time](https://docs.aws.amazon.com/en_us/kms/latest/developerguide/importing-keys.html#importing-keys-expiration) in the *Key Management Service Developer Guide*.
     *
     * When the value of `ExpirationModel` is `KEY_MATERIAL_EXPIRES`, you must specify a value for the `ValidTo` parameter. When value is `KEY_MATERIAL_DOES_NOT_EXPIRE`, you must omit the `ValidTo` parameter.
     *
     * You cannot change the `ExpirationModel` or `ValidTo` values for the current import after the request completes. To change either value, you must reimport the key material.
     */
    public val expirationModel: aws.sdk.kotlin.services.kms.model.ExpirationModelType? = builder.expirationModel
    /**
     * The import token that you received in the response to a previous GetParametersForImport request. It must be from the same response that contained the public key that you used to encrypt the key material.
     */
    public val importToken: kotlin.ByteArray? = builder.importToken
    /**
     * The identifier of the KMS key that will be associated with the imported key material. This must be the same KMS key specified in the `KeyID` parameter of the corresponding GetParametersForImport request. The `Origin` of the KMS key must be `EXTERNAL` and its `KeyState` must be `PendingImport`.
     *
     * The KMS key can be a symmetric encryption KMS key, HMAC KMS key, asymmetric encryption KMS key, or asymmetric signing KMS key, including a [multi-Region key](kms/latest/developerguide/multi-region-keys-overview.html) of any supported type. You cannot perform this operation on a KMS key in a custom key store, or on a KMS key in a different Amazon Web Services account.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The date and time when the imported key material expires. This parameter is required when the value of the `ExpirationModel` parameter is `KEY_MATERIAL_EXPIRES`. Otherwise it is not valid.
     *
     * The value of this parameter must be a future date and time. The maximum value is 365 days from the request date.
     *
     * When the key material expires, KMS deletes the key material from the KMS key. Without its key material, the KMS key is unusable. To use the KMS key in cryptographic operations, you must reimport the same key material.
     *
     * You cannot change the `ExpirationModel` or `ValidTo` values for the current import after the request completes. To change either value, you must delete (DeleteImportedKeyMaterial) and reimport the key material.
     */
    public val validTo: aws.smithy.kotlin.runtime.time.Instant? = builder.validTo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ImportKeyMaterialRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportKeyMaterialRequest(")
        append("encryptedKeyMaterial=$encryptedKeyMaterial,")
        append("expirationModel=$expirationModel,")
        append("importToken=$importToken,")
        append("keyId=$keyId,")
        append("validTo=$validTo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptedKeyMaterial?.contentHashCode() ?: 0
        result = 31 * result + (expirationModel?.hashCode() ?: 0)
        result = 31 * result + (importToken?.contentHashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (validTo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportKeyMaterialRequest

        if (encryptedKeyMaterial != null) {
            if (other.encryptedKeyMaterial == null) return false
            if (!encryptedKeyMaterial.contentEquals(other.encryptedKeyMaterial)) return false
        } else if (other.encryptedKeyMaterial != null) return false
        if (expirationModel != other.expirationModel) return false
        if (importToken != null) {
            if (other.importToken == null) return false
            if (!importToken.contentEquals(other.importToken)) return false
        } else if (other.importToken != null) return false
        if (keyId != other.keyId) return false
        if (validTo != other.validTo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ImportKeyMaterialRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encrypted key material to import. The key material must be encrypted under the public wrapping key that GetParametersForImport returned, using the wrapping algorithm that you specified in the same `GetParametersForImport` request.
         */
        public var encryptedKeyMaterial: kotlin.ByteArray? = null
        /**
         * Specifies whether the key material expires. The default is `KEY_MATERIAL_EXPIRES`. For help with this choice, see [Setting an expiration time](https://docs.aws.amazon.com/en_us/kms/latest/developerguide/importing-keys.html#importing-keys-expiration) in the *Key Management Service Developer Guide*.
         *
         * When the value of `ExpirationModel` is `KEY_MATERIAL_EXPIRES`, you must specify a value for the `ValidTo` parameter. When value is `KEY_MATERIAL_DOES_NOT_EXPIRE`, you must omit the `ValidTo` parameter.
         *
         * You cannot change the `ExpirationModel` or `ValidTo` values for the current import after the request completes. To change either value, you must reimport the key material.
         */
        public var expirationModel: aws.sdk.kotlin.services.kms.model.ExpirationModelType? = null
        /**
         * The import token that you received in the response to a previous GetParametersForImport request. It must be from the same response that contained the public key that you used to encrypt the key material.
         */
        public var importToken: kotlin.ByteArray? = null
        /**
         * The identifier of the KMS key that will be associated with the imported key material. This must be the same KMS key specified in the `KeyID` parameter of the corresponding GetParametersForImport request. The `Origin` of the KMS key must be `EXTERNAL` and its `KeyState` must be `PendingImport`.
         *
         * The KMS key can be a symmetric encryption KMS key, HMAC KMS key, asymmetric encryption KMS key, or asymmetric signing KMS key, including a [multi-Region key](kms/latest/developerguide/multi-region-keys-overview.html) of any supported type. You cannot perform this operation on a KMS key in a custom key store, or on a KMS key in a different Amazon Web Services account.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * The date and time when the imported key material expires. This parameter is required when the value of the `ExpirationModel` parameter is `KEY_MATERIAL_EXPIRES`. Otherwise it is not valid.
         *
         * The value of this parameter must be a future date and time. The maximum value is 365 days from the request date.
         *
         * When the key material expires, KMS deletes the key material from the KMS key. Without its key material, the KMS key is unusable. To use the KMS key in cryptographic operations, you must reimport the same key material.
         *
         * You cannot change the `ExpirationModel` or `ValidTo` values for the current import after the request completes. To change either value, you must delete (DeleteImportedKeyMaterial) and reimport the key material.
         */
        public var validTo: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ImportKeyMaterialRequest) : this() {
            this.encryptedKeyMaterial = x.encryptedKeyMaterial
            this.expirationModel = x.expirationModel
            this.importToken = x.importToken
            this.keyId = x.keyId
            this.validTo = x.validTo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ImportKeyMaterialRequest = ImportKeyMaterialRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
