// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateRandomResponse private constructor(builder: Builder) {
    /**
     * The plaintext random bytes encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
     *
     * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val ciphertextForRecipient: kotlin.ByteArray? = builder.ciphertextForRecipient
    /**
     * The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     *
     * If the response includes the `CiphertextForRecipient` field, the `Plaintext` field is null or empty.
     */
    public val plaintext: kotlin.ByteArray? = builder.plaintext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateRandomResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateRandomResponse(")
        append("ciphertextForRecipient=$ciphertextForRecipient,")
        append("plaintext=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextForRecipient?.contentHashCode() ?: 0
        result = 31 * result + (plaintext?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateRandomResponse

        if (ciphertextForRecipient != null) {
            if (other.ciphertextForRecipient == null) return false
            if (!ciphertextForRecipient.contentEquals(other.ciphertextForRecipient)) return false
        } else if (other.ciphertextForRecipient != null) return false
        if (plaintext != null) {
            if (other.plaintext == null) return false
            if (!plaintext.contentEquals(other.plaintext)) return false
        } else if (other.plaintext != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateRandomResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The plaintext random bytes encrypted with the public key from the Nitro enclave. This ciphertext can be decrypted only by using a private key in the Nitro enclave.
         *
         * This field is included in the response only when the `Recipient` parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var ciphertextForRecipient: kotlin.ByteArray? = null
        /**
         * The random byte string. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         *
         * If the response includes the `CiphertextForRecipient` field, the `Plaintext` field is null or empty.
         */
        public var plaintext: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateRandomResponse) : this() {
            this.ciphertextForRecipient = x.ciphertextForRecipient
            this.plaintext = x.plaintext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateRandomResponse = GenerateRandomResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
