// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class CreateKeyRequest private constructor(builder: Builder) {
    /**
     * Skips ("bypasses") the key policy lockout safety check. The default value is false.
     *
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     *
     * For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*.
     *
     * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent PutKeyPolicy request on the KMS key.
     */
    public val bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = builder.bypassPolicyLockoutSafetyCheck
    /**
     * Creates the KMS key in the specified [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html). The `ConnectionState` of the custom key store must be `CONNECTED`. To find the CustomKeyStoreID and ConnectionState use the DescribeCustomKeyStores operation.
     *
     * This parameter is valid only for symmetric encryption KMS keys in a single Region. You cannot create any other type of KMS key in a custom key store.
     *
     * When you create a KMS key in an CloudHSM key store, KMS generates a non-exportable 256-bit symmetric key in its associated CloudHSM cluster and associates it with the KMS key. When you create a KMS key in an external key store, you must use the `XksKeyId` parameter to specify an external key that serves as key material for the KMS key.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * Instead, use the `KeySpec` parameter.
     *
     * The `KeySpec` and `CustomerMasterKeySpec` parameters work the same way. Only the names differ. We recommend that you use `KeySpec` parameter in your code. However, to avoid breaking changes, KMS supports both parameters.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = builder.customerMasterKeySpec
    /**
     * A description of the KMS key. Use a description that helps you decide whether the KMS key is appropriate for a task. The default value is an empty string (no description).
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * To set or change the description after the key is created, use UpdateKeyDescription.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the type of KMS key to create. The default value, `SYMMETRIC_DEFAULT`, creates a KMS key with a 256-bit AES-GCM key that is used for encryption and decryption, except in China Regions, where it creates a 128-bit symmetric key that uses SM4 encryption. For help choosing a key spec for your KMS key, see [Choosing a KMS key type](https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html#symm-asymm-choose) in the **Key Management Service Developer Guide**.
     *
     * The `KeySpec` determines whether the KMS key contains a symmetric key or an asymmetric key pair. It also determines the algorithms that the KMS key supports. You can't change the `KeySpec` after the KMS key is created. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see [kms:EncryptionAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm), [kms:MacAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-mac-algorithm) or [kms:Signing Algorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm) in the **Key Management Service Developer Guide**.
     *
     * [Amazon Web Services services that are integrated with KMS](http://aws.amazon.com/kms/features/#AWS_Service_Integration) use symmetric encryption KMS keys to protect your data. These services do not support asymmetric KMS keys or HMAC KMS keys.
     *
     * KMS supports the following key specs for KMS keys:
     * + Symmetric encryption key (default)
     *    + `SYMMETRIC_DEFAULT`
     * + HMAC keys (symmetric)
     *    + `HMAC_224`
     *    + `HMAC_256`
     *    + `HMAC_384`
     *    + `HMAC_512`
     * + Asymmetric RSA key pairs
     *    + `RSA_2048`
     *    + `RSA_3072`
     *    + `RSA_4096`
     * + Asymmetric NIST-recommended elliptic curve key pairs
     *    + `ECC_NIST_P256` (secp256r1)
     *    + `ECC_NIST_P384` (secp384r1)
     *    + `ECC_NIST_P521` (secp521r1)
     * + Other asymmetric elliptic curve key pairs
     *    + `ECC_SECG_P256K1` (secp256k1), commonly used for cryptocurrencies.
     * + SM2 key pairs (China Regions only)
     *    + `SM2`
     */
    public val keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = builder.keySpec
    /**
     * Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT`. This parameter is optional when you are creating a symmetric encryption KMS key; otherwise, it is required. You can't change the `KeyUsage` value after the KMS key is created.
     *
     * Select only one valid value.
     * + For symmetric encryption KMS keys, omit the parameter or specify `ENCRYPT_DECRYPT`.
     * + For HMAC KMS keys (symmetric), specify `GENERATE_VERIFY_MAC`.
     * + For asymmetric KMS keys with RSA key material, specify `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
     * + For asymmetric KMS keys with ECC key material, specify `SIGN_VERIFY`.
     * + For asymmetric KMS keys with SM2 key material (China Regions only), specify `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
     */
    public val keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = builder.keyUsage
    /**
     * Creates a multi-Region primary key that you can replicate into other Amazon Web Services Regions. You cannot change this value after you create the KMS key.
     *
     * For a multi-Region key, set this parameter to `True`. For a single-Region KMS key, omit this parameter or set it to `False`. The default value is `False`.
     *
     * This operation supports *multi-Region keys*, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see [Multi-Region keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
     *
     * This value creates a *primary key*, not a replica. To create a *replica key*, use the ReplicateKey operation.
     *
     * You can create a symmetric or asymmetric multi-Region key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
     */
    public val multiRegion: kotlin.Boolean? = builder.multiRegion
    /**
     * The source of the key material for the KMS key. You cannot change the origin after you create the KMS key. The default is `AWS_KMS`, which means that KMS creates the key material.
     *
     * To [create a KMS key with no key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html) (for imported key material), set this value to `EXTERNAL`. For more information about importing key material into KMS, see [Importing Key Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) in the *Key Management Service Developer Guide*. The `EXTERNAL` origin value is valid only for symmetric KMS keys.
     *
     * To [create a KMS key in an CloudHSM key store](https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html) and create its key material in the associated CloudHSM cluster, set this value to `AWS_CLOUDHSM`. You must also use the `CustomKeyStoreId` parameter to identify the CloudHSM key store. The `KeySpec` value must be `SYMMETRIC_DEFAULT`.
     *
     * To [create a KMS key in an external key store](https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keys.html), set this value to `EXTERNAL_KEY_STORE`. You must also use the `CustomKeyStoreId` parameter to identify the external key store and the `XksKeyId` parameter to identify the associated external key. The `KeySpec` value must be `SYMMETRIC_DEFAULT`.
     */
    public val origin: aws.sdk.kotlin.services.kms.model.OriginType? = builder.origin
    /**
     * The key policy to attach to the KMS key.
     *
     * If you provide a key policy, it must meet the following criteria:
     * + The key policy must allow the calling principal to make a subsequent `PutKeyPolicy` request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*. (To omit this condition, set `BypassPolicyLockoutSafetyCheck` to true.)
     * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal, you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the *Amazon Web Services Identity and Access Management User Guide*.
     *
     * If you do not provide a key policy, KMS attaches a default key policy to the KMS key. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) in the *Key Management Service Developer Guide*.
     *
     * The key policy size quota is 32 kilobytes (32768 bytes).
     *
     * For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * Assigns one or more tags to the KMS key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the TagResource operation.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see [ABAC for KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *Key Management Service Developer Guide*.
     *
     * To use this parameter, you must have [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html) permission in an IAM policy.
     *
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
     *
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see [Tagging Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Identifies the [external key](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key) that serves as key material for the KMS key in an [external key store](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html). Specify the ID that the [external key store proxy](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-xks-proxy) uses to refer to the external key. For help, see the documentation for your external key store proxy.
     *
     * This parameter is required for a KMS key with an `Origin` value of `EXTERNAL_KEY_STORE`. It is not valid for KMS keys with any other `Origin` value.
     *
     * The external key must be an existing 256-bit AES symmetric encryption key hosted outside of Amazon Web Services in an external key manager associated with the external key store specified by the `CustomKeyStoreId` parameter. This key must be enabled and configured to perform encryption and decryption. Each KMS key in an external key store must use a different external key. For details, see [Requirements for a KMS key in an external key store](https://docs.aws.amazon.com/create-xks-keys.html#xks-key-requirements) in the *Key Management Service Developer Guide*.
     *
     * Each KMS key in an external key store is associated two backing keys. One is key material that KMS generates. The other is the external key specified by this parameter. When you use the KMS key in an external key store to encrypt data, the encryption operation is performed first by KMS using the KMS key material, and then by the external key manager using the specified external key, a process known as *double encryption*. For details, see [Double encryption](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-double-encryption) in the *Key Management Service Developer Guide*.
     */
    public val xksKeyId: kotlin.String? = builder.xksKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.CreateKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKeyRequest(")
        append("bypassPolicyLockoutSafetyCheck=$bypassPolicyLockoutSafetyCheck,")
        append("customKeyStoreId=$customKeyStoreId,")
        append("customerMasterKeySpec=$customerMasterKeySpec,")
        append("description=$description,")
        append("keySpec=$keySpec,")
        append("keyUsage=$keyUsage,")
        append("multiRegion=$multiRegion,")
        append("origin=$origin,")
        append("policy=$policy,")
        append("tags=$tags,")
        append("xksKeyId=$xksKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassPolicyLockoutSafetyCheck?.hashCode() ?: 0
        result = 31 * result + (customKeyStoreId?.hashCode() ?: 0)
        result = 31 * result + (customerMasterKeySpec?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keySpec?.hashCode() ?: 0)
        result = 31 * result + (keyUsage?.hashCode() ?: 0)
        result = 31 * result + (multiRegion?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (xksKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKeyRequest

        if (bypassPolicyLockoutSafetyCheck != other.bypassPolicyLockoutSafetyCheck) return false
        if (customKeyStoreId != other.customKeyStoreId) return false
        if (customerMasterKeySpec != other.customerMasterKeySpec) return false
        if (description != other.description) return false
        if (keySpec != other.keySpec) return false
        if (keyUsage != other.keyUsage) return false
        if (multiRegion != other.multiRegion) return false
        if (origin != other.origin) return false
        if (policy != other.policy) return false
        if (tags != other.tags) return false
        if (xksKeyId != other.xksKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.CreateKeyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Skips ("bypasses") the key policy lockout safety check. The default value is false.
         *
         * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
         *
         * For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*.
         *
         * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent PutKeyPolicy request on the KMS key.
         */
        public var bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = null
        /**
         * Creates the KMS key in the specified [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html). The `ConnectionState` of the custom key store must be `CONNECTED`. To find the CustomKeyStoreID and ConnectionState use the DescribeCustomKeyStores operation.
         *
         * This parameter is valid only for symmetric encryption KMS keys in a single Region. You cannot create any other type of KMS key in a custom key store.
         *
         * When you create a KMS key in an CloudHSM key store, KMS generates a non-exportable 256-bit symmetric key in its associated CloudHSM cluster and associates it with the KMS key. When you create a KMS key in an external key store, you must use the `XksKeyId` parameter to specify an external key that serves as key material for the KMS key.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * Instead, use the `KeySpec` parameter.
         *
         * The `KeySpec` and `CustomerMasterKeySpec` parameters work the same way. Only the names differ. We recommend that you use `KeySpec` parameter in your code. However, to avoid breaking changes, KMS supports both parameters.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = null
        /**
         * A description of the KMS key. Use a description that helps you decide whether the KMS key is appropriate for a task. The default value is an empty string (no description).
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * To set or change the description after the key is created, use UpdateKeyDescription.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the type of KMS key to create. The default value, `SYMMETRIC_DEFAULT`, creates a KMS key with a 256-bit AES-GCM key that is used for encryption and decryption, except in China Regions, where it creates a 128-bit symmetric key that uses SM4 encryption. For help choosing a key spec for your KMS key, see [Choosing a KMS key type](https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html#symm-asymm-choose) in the **Key Management Service Developer Guide**.
         *
         * The `KeySpec` determines whether the KMS key contains a symmetric key or an asymmetric key pair. It also determines the algorithms that the KMS key supports. You can't change the `KeySpec` after the KMS key is created. To further restrict the algorithms that can be used with the KMS key, use a condition key in its key policy or IAM policy. For more information, see [kms:EncryptionAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm), [kms:MacAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-mac-algorithm) or [kms:Signing Algorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm) in the **Key Management Service Developer Guide**.
         *
         * [Amazon Web Services services that are integrated with KMS](http://aws.amazon.com/kms/features/#AWS_Service_Integration) use symmetric encryption KMS keys to protect your data. These services do not support asymmetric KMS keys or HMAC KMS keys.
         *
         * KMS supports the following key specs for KMS keys:
         * + Symmetric encryption key (default)
         *    + `SYMMETRIC_DEFAULT`
         * + HMAC keys (symmetric)
         *    + `HMAC_224`
         *    + `HMAC_256`
         *    + `HMAC_384`
         *    + `HMAC_512`
         * + Asymmetric RSA key pairs
         *    + `RSA_2048`
         *    + `RSA_3072`
         *    + `RSA_4096`
         * + Asymmetric NIST-recommended elliptic curve key pairs
         *    + `ECC_NIST_P256` (secp256r1)
         *    + `ECC_NIST_P384` (secp384r1)
         *    + `ECC_NIST_P521` (secp521r1)
         * + Other asymmetric elliptic curve key pairs
         *    + `ECC_SECG_P256K1` (secp256k1), commonly used for cryptocurrencies.
         * + SM2 key pairs (China Regions only)
         *    + `SM2`
         */
        public var keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = null
        /**
         * Determines the [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key. The default value is `ENCRYPT_DECRYPT`. This parameter is optional when you are creating a symmetric encryption KMS key; otherwise, it is required. You can't change the `KeyUsage` value after the KMS key is created.
         *
         * Select only one valid value.
         * + For symmetric encryption KMS keys, omit the parameter or specify `ENCRYPT_DECRYPT`.
         * + For HMAC KMS keys (symmetric), specify `GENERATE_VERIFY_MAC`.
         * + For asymmetric KMS keys with RSA key material, specify `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
         * + For asymmetric KMS keys with ECC key material, specify `SIGN_VERIFY`.
         * + For asymmetric KMS keys with SM2 key material (China Regions only), specify `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
         */
        public var keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = null
        /**
         * Creates a multi-Region primary key that you can replicate into other Amazon Web Services Regions. You cannot change this value after you create the KMS key.
         *
         * For a multi-Region key, set this parameter to `True`. For a single-Region KMS key, omit this parameter or set it to `False`. The default value is `False`.
         *
         * This operation supports *multi-Region keys*, an KMS feature that lets you create multiple interoperable KMS keys in different Amazon Web Services Regions. Because these KMS keys have the same key ID, key material, and other metadata, you can use them interchangeably to encrypt data in one Amazon Web Services Region and decrypt it in a different Amazon Web Services Region without re-encrypting the data or making a cross-Region call. For more information about multi-Region keys, see [Multi-Region keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
         *
         * This value creates a *primary key*, not a replica. To create a *replica key*, use the ReplicateKey operation.
         *
         * You can create a symmetric or asymmetric multi-Region key, and you can create a multi-Region key with imported key material. However, you cannot create a multi-Region key in a custom key store.
         */
        public var multiRegion: kotlin.Boolean? = null
        /**
         * The source of the key material for the KMS key. You cannot change the origin after you create the KMS key. The default is `AWS_KMS`, which means that KMS creates the key material.
         *
         * To [create a KMS key with no key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-create-cmk.html) (for imported key material), set this value to `EXTERNAL`. For more information about importing key material into KMS, see [Importing Key Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) in the *Key Management Service Developer Guide*. The `EXTERNAL` origin value is valid only for symmetric KMS keys.
         *
         * To [create a KMS key in an CloudHSM key store](https://docs.aws.amazon.com/kms/latest/developerguide/create-cmk-keystore.html) and create its key material in the associated CloudHSM cluster, set this value to `AWS_CLOUDHSM`. You must also use the `CustomKeyStoreId` parameter to identify the CloudHSM key store. The `KeySpec` value must be `SYMMETRIC_DEFAULT`.
         *
         * To [create a KMS key in an external key store](https://docs.aws.amazon.com/kms/latest/developerguide/create-xks-keys.html), set this value to `EXTERNAL_KEY_STORE`. You must also use the `CustomKeyStoreId` parameter to identify the external key store and the `XksKeyId` parameter to identify the associated external key. The `KeySpec` value must be `SYMMETRIC_DEFAULT`.
         */
        public var origin: aws.sdk.kotlin.services.kms.model.OriginType? = null
        /**
         * The key policy to attach to the KMS key.
         *
         * If you provide a key policy, it must meet the following criteria:
         * + The key policy must allow the calling principal to make a subsequent `PutKeyPolicy` request on the KMS key. This reduces the risk that the KMS key becomes unmanageable. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-default.html#prevent-unmanageable-key) in the *Key Management Service Developer Guide*. (To omit this condition, set `BypassPolicyLockoutSafetyCheck` to true.)
         * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal, you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the *Amazon Web Services Identity and Access Management User Guide*.
         *
         * If you do not provide a key policy, KMS attaches a default key policy to the KMS key. For more information, see [Default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) in the *Key Management Service Developer Guide*.
         *
         * The key policy size quota is 32 kilobytes (32768 bytes).
         *
         * For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
         */
        public var policy: kotlin.String? = null
        /**
         * Assigns one or more tags to the KMS key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the TagResource operation.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see [ABAC for KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *Key Management Service Developer Guide*.
         *
         * To use this parameter, you must have [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html) permission in an IAM policy.
         *
         * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
         *
         * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see [Tagging Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
         */
        public var tags: List<Tag>? = null
        /**
         * Identifies the [external key](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key) that serves as key material for the KMS key in an [external key store](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html). Specify the ID that the [external key store proxy](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-xks-proxy) uses to refer to the external key. For help, see the documentation for your external key store proxy.
         *
         * This parameter is required for a KMS key with an `Origin` value of `EXTERNAL_KEY_STORE`. It is not valid for KMS keys with any other `Origin` value.
         *
         * The external key must be an existing 256-bit AES symmetric encryption key hosted outside of Amazon Web Services in an external key manager associated with the external key store specified by the `CustomKeyStoreId` parameter. This key must be enabled and configured to perform encryption and decryption. Each KMS key in an external key store must use a different external key. For details, see [Requirements for a KMS key in an external key store](https://docs.aws.amazon.com/create-xks-keys.html#xks-key-requirements) in the *Key Management Service Developer Guide*.
         *
         * Each KMS key in an external key store is associated two backing keys. One is key material that KMS generates. The other is the external key specified by this parameter. When you use the KMS key in an external key store to encrypt data, the encryption operation is performed first by KMS using the KMS key material, and then by the external key manager using the specified external key, a process known as *double encryption*. For details, see [Double encryption](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-double-encryption) in the *Key Management Service Developer Guide*.
         */
        public var xksKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.CreateKeyRequest) : this() {
            this.bypassPolicyLockoutSafetyCheck = x.bypassPolicyLockoutSafetyCheck
            this.customKeyStoreId = x.customKeyStoreId
            this.customerMasterKeySpec = x.customerMasterKeySpec
            this.description = x.description
            this.keySpec = x.keySpec
            this.keyUsage = x.keyUsage
            this.multiRegion = x.multiRegion
            this.origin = x.origin
            this.policy = x.policy
            this.tags = x.tags
            this.xksKeyId = x.xksKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.CreateKeyRequest = CreateKeyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
