// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.VerifyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class VerifyOperationDeserializer: HttpDeserialize<VerifyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): VerifyResponse {
        if (!response.status.isSuccess()) {
            throwVerifyError(context, response)
        }
        val builder = VerifyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeVerifyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwVerifyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidSignatureException" -> KmsInvalidSignatureExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeVerifyOperationBody(builder: VerifyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val SIGNATUREVALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SignatureValid"))
    val SIGNINGALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SigningAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYID_DESCRIPTOR)
        field(SIGNATUREVALID_DESCRIPTOR)
        field(SIGNINGALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                SIGNATUREVALID_DESCRIPTOR.index -> builder.signatureValid = deserializeBoolean()
                SIGNINGALGORITHM_DESCRIPTOR.index -> builder.signingAlgorithm = deserializeString().let { SigningAlgorithmSpec.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
