// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.VerifyMacResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class VerifyMacOperationDeserializer: HttpDeserialize<VerifyMacResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): VerifyMacResponse {
        if (!response.status.isSuccess()) {
            throwVerifyMacError(context, response)
        }
        val builder = VerifyMacResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeVerifyMacOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwVerifyMacError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidMacException" -> KmsInvalidMacExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeVerifyMacOperationBody(builder: VerifyMacResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val MACALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MacAlgorithm"))
    val MACVALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("MacValid"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYID_DESCRIPTOR)
        field(MACALGORITHM_DESCRIPTOR)
        field(MACVALID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                MACALGORITHM_DESCRIPTOR.index -> builder.macAlgorithm = deserializeString().let { MacAlgorithmSpec.fromValue(it) }
                MACVALID_DESCRIPTOR.index -> builder.macValid = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
