// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.UpdatePrimaryRegionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdatePrimaryRegionOperationDeserializer: HttpDeserialize<UpdatePrimaryRegionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdatePrimaryRegionResponse {
        if (!response.status.isSuccess()) {
            throwUpdatePrimaryRegionError(context, response)
        }
        val builder = UpdatePrimaryRegionResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdatePrimaryRegionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
