// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.ReEncryptResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class ReEncryptOperationDeserializer: HttpDeserialize<ReEncryptResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ReEncryptResponse {
        if (!response.status.isSuccess()) {
            throwReEncryptError(context, response)
        }
        val builder = ReEncryptResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeReEncryptOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwReEncryptError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncorrectKeyException" -> IncorrectKeyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidCiphertextException" -> InvalidCiphertextExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeReEncryptOperationBody(builder: ReEncryptResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CIPHERTEXTBLOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("CiphertextBlob"))
    val DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DestinationEncryptionAlgorithm"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val SOURCEENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SourceEncryptionAlgorithm"))
    val SOURCEKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceKeyId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIPHERTEXTBLOB_DESCRIPTOR)
        field(DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(SOURCEENCRYPTIONALGORITHM_DESCRIPTOR)
        field(SOURCEKEYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CIPHERTEXTBLOB_DESCRIPTOR.index -> builder.ciphertextBlob = deserializeString().decodeBase64Bytes()
                DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR.index -> builder.destinationEncryptionAlgorithm = deserializeString().let { EncryptionAlgorithmSpec.fromValue(it) }
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                SOURCEENCRYPTIONALGORITHM_DESCRIPTOR.index -> builder.sourceEncryptionAlgorithm = deserializeString().let { EncryptionAlgorithmSpec.fromValue(it) }
                SOURCEKEYID_DESCRIPTOR.index -> builder.sourceKeyId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
