// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec
import aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.GetPublicKeyResponse
import aws.sdk.kotlin.services.kms.model.KeySpec
import aws.sdk.kotlin.services.kms.model.KeyUsageType
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes
import kotlin.collections.mutableListOf


internal class GetPublicKeyOperationDeserializer: HttpDeserialize<GetPublicKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetPublicKeyResponse {
        if (!response.status.isSuccess()) {
            throwGetPublicKeyError(context, response)
        }
        val builder = GetPublicKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPublicKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPublicKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperationException" -> UnsupportedOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPublicKeyOperationBody(builder: GetPublicKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMERMASTERKEYSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("CustomerMasterKeySpec"))
    val ENCRYPTIONALGORITHMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EncryptionAlgorithms"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val KEYSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeySpec"))
    val KEYUSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("KeyUsage"))
    val PUBLICKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("PublicKey"))
    val SIGNINGALGORITHMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SigningAlgorithms"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMERMASTERKEYSPEC_DESCRIPTOR)
        field(ENCRYPTIONALGORITHMS_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(KEYSPEC_DESCRIPTOR)
        field(KEYUSAGE_DESCRIPTOR)
        field(PUBLICKEY_DESCRIPTOR)
        field(SIGNINGALGORITHMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMERMASTERKEYSPEC_DESCRIPTOR.index -> builder.customerMasterKeySpec = deserializeString().let { CustomerMasterKeySpec.fromValue(it) }
                ENCRYPTIONALGORITHMS_DESCRIPTOR.index -> builder.encryptionAlgorithms =
                    deserializer.deserializeList(ENCRYPTIONALGORITHMS_DESCRIPTOR) {
                        val col0 = mutableListOf<EncryptionAlgorithmSpec>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { EncryptionAlgorithmSpec.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                KEYSPEC_DESCRIPTOR.index -> builder.keySpec = deserializeString().let { KeySpec.fromValue(it) }
                KEYUSAGE_DESCRIPTOR.index -> builder.keyUsage = deserializeString().let { KeyUsageType.fromValue(it) }
                PUBLICKEY_DESCRIPTOR.index -> builder.publicKey = deserializeString().decodeBase64Bytes()
                SIGNINGALGORITHMS_DESCRIPTOR.index -> builder.signingAlgorithms =
                    deserializer.deserializeList(SIGNINGALGORITHMS_DESCRIPTOR) {
                        val col0 = mutableListOf<SigningAlgorithmSpec>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { SigningAlgorithmSpec.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
