// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.GenerateMacResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.MacAlgorithmSpec
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class GenerateMacOperationDeserializer: HttpDeserialize<GenerateMacResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GenerateMacResponse {
        if (!response.status.isSuccess()) {
            throwGenerateMacError(context, response)
        }
        val builder = GenerateMacResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGenerateMacOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGenerateMacError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DisabledException" -> DisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "DryRunOperationException" -> DryRunOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantTokenException" -> InvalidGrantTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyUsageException" -> InvalidKeyUsageExceptionDeserializer().deserialize(context, wrappedResponse)
        "KeyUnavailableException" -> KeyUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGenerateMacOperationBody(builder: GenerateMacResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val MAC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Mac"))
    val MACALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("MacAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYID_DESCRIPTOR)
        field(MAC_DESCRIPTOR)
        field(MACALGORITHM_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                MAC_DESCRIPTOR.index -> builder.mac = deserializeString().decodeBase64Bytes()
                MACALGORITHM_DESCRIPTOR.index -> builder.macAlgorithm = deserializeString().let { MacAlgorithmSpec.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
