// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomKeyStoreOperationDeserializer: HttpDeserialize<CreateCustomKeyStoreResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCustomKeyStoreResponse {
        if (!response.status.isSuccess()) {
            throwCreateCustomKeyStoreError(context, response)
        }
        val builder = CreateCustomKeyStoreResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCustomKeyStoreOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCustomKeyStoreError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CloudHsmClusterInUseException" -> CloudHsmClusterInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmClusterInvalidConfigurationException" -> CloudHsmClusterInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmClusterNotActiveException" -> CloudHsmClusterNotActiveExceptionDeserializer().deserialize(context, wrappedResponse)
        "CloudHsmClusterNotFoundException" -> CloudHsmClusterNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "CustomKeyStoreNameInUseException" -> CustomKeyStoreNameInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncorrectTrustAnchorException" -> IncorrectTrustAnchorExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyIncorrectAuthenticationCredentialException" -> XksProxyIncorrectAuthenticationCredentialExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyInvalidConfigurationException" -> XksProxyInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyInvalidResponseException" -> XksProxyInvalidResponseExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyUriEndpointInUseException" -> XksProxyUriEndpointInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyUriInUseException" -> XksProxyUriInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyUriUnreachableException" -> XksProxyUriUnreachableExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyVpcEndpointServiceInUseException" -> XksProxyVpcEndpointServiceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyVpcEndpointServiceInvalidConfigurationException" -> XksProxyVpcEndpointServiceInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "XksProxyVpcEndpointServiceNotFoundException" -> XksProxyVpcEndpointServiceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCustomKeyStoreOperationBody(builder: CreateCustomKeyStoreResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMKEYSTOREID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomKeyStoreId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMKEYSTOREID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMKEYSTOREID_DESCRIPTOR.index -> builder.customKeyStoreId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
