// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



/**
 * Detailed information about the external key store proxy (XKS proxy). Your external key store proxy translates KMS requests into a format that your external key manager can understand. These fields appear in a DescribeCustomKeyStores response only when the `CustomKeyStoreType` is `EXTERNAL_KEY_STORE`.
 */
public class XksProxyConfigurationType private constructor(builder: Builder) {
    /**
     * The part of the external key store [proxy authentication credential](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential) that uniquely identifies the secret access key.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.
     */
    public val connectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = builder.connectivity
    /**
     * The URI endpoint for the external key store proxy.
     *
     * If the external key store proxy has a public endpoint, it is displayed here.
     *
     * If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.
     */
    public val uriEndpoint: kotlin.String? = builder.uriEndpoint
    /**
     * The path to the external key store proxy APIs.
     */
    public val uriPath: kotlin.String? = builder.uriPath
    /**
     * The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.
     */
    public val vpcEndpointServiceName: kotlin.String? = builder.vpcEndpointServiceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.XksProxyConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XksProxyConfigurationType(")
        append("accessKeyId=*** Sensitive Data Redacted ***,")
        append("connectivity=$connectivity,")
        append("uriEndpoint=$uriEndpoint,")
        append("uriPath=$uriPath,")
        append("vpcEndpointServiceName=$vpcEndpointServiceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (connectivity?.hashCode() ?: 0)
        result = 31 * result + (uriEndpoint?.hashCode() ?: 0)
        result = 31 * result + (uriPath?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XksProxyConfigurationType

        if (accessKeyId != other.accessKeyId) return false
        if (connectivity != other.connectivity) return false
        if (uriEndpoint != other.uriEndpoint) return false
        if (uriPath != other.uriPath) return false
        if (vpcEndpointServiceName != other.vpcEndpointServiceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.XksProxyConfigurationType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The part of the external key store [proxy authentication credential](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential) that uniquely identifies the secret access key.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.
         */
        public var connectivity: aws.sdk.kotlin.services.kms.model.XksProxyConnectivityType? = null
        /**
         * The URI endpoint for the external key store proxy.
         *
         * If the external key store proxy has a public endpoint, it is displayed here.
         *
         * If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.
         */
        public var uriEndpoint: kotlin.String? = null
        /**
         * The path to the external key store proxy APIs.
         */
        public var uriPath: kotlin.String? = null
        /**
         * The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.
         */
        public var vpcEndpointServiceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.XksProxyConfigurationType) : this() {
            this.accessKeyId = x.accessKeyId
            this.connectivity = x.connectivity
            this.uriEndpoint = x.uriEndpoint
            this.uriPath = x.uriPath
            this.vpcEndpointServiceName = x.vpcEndpointServiceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.XksProxyConfigurationType = XksProxyConfigurationType(this)
    }
}
