// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



/**
 * Information about the [external key ](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key)that is associated with a KMS key in an external key store.
 *
 * This element appears in a CreateKey or DescribeKey response only for a KMS key in an external key store.
 *
 * The *external key* is a symmetric encryption key that is hosted by an external key manager outside of Amazon Web Services. When you use the KMS key in an external key store in a cryptographic operation, the cryptographic operation is performed in the external key manager using the specified external key. For more information, see [External key](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key) in the *Key Management Service Developer Guide*.
 */
public class XksKeyConfigurationType private constructor(builder: Builder) {
    /**
     * The ID of the external key in its external key manager. This is the ID that the external key store proxy uses to identify the external key.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XksKeyConfigurationType(")
        append("id=$id")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XksKeyConfigurationType

        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the external key in its external key manager. This is the ID that the external key store proxy uses to identify the external key.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType) : this() {
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType = XksKeyConfigurationType(this)
    }
}
