// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class VerifyRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the `MessageType` parameter with a value of `DIGEST`.
     *
     * If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.
     */
    public val message: kotlin.ByteArray? = builder.message
    /**
     * Tells KMS whether the value of the `Message` parameter should be hashed as part of the signing algorithm. Use `RAW` for unhashed messages; use `DIGEST` for message digests, which are already hashed.
     *
     * When the value of `MessageType` is `RAW`, KMS uses the standard signing algorithm, which begins with a hash function. When the value is `DIGEST`, KMS skips the hashing step in the signing algorithm.
     *
     * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with an unhashed message, the security of the verification operation can be compromised.
     *
     * When the value of `MessageType`is `DIGEST`, the length of the `Message` value must match the length of hashed messages for the specified signing algorithm.
     *
     * You can submit a message digest and omit the `MessageType` or specify `RAW` so the digest is hashed again while signing. However, if the signed message is hashed once while signing, but twice while verifying, verification fails, even when the message hasn't changed.
     *
     * The hashing algorithm in that `Verify` uses is based on the `SigningAlgorithm` value.
     * + Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.
     * + Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.
     * + Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.
     * + SM2DSA uses the SM3 hashing algorithm. For details, see [Offline verification with SM2 key pairs](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
     */
    public val messageType: aws.sdk.kotlin.services.kms.model.MessageType? = builder.messageType
    /**
     * The signature that the `Sign` operation generated.
     */
    public val signature: kotlin.ByteArray? = builder.signature
    /**
     * The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.VerifyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyRequest(")
        append("dryRun=$dryRun,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageType=$messageType,")
        append("signature=$signature,")
        append("signingAlgorithm=$signingAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (signature?.contentHashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyRequest

        if (dryRun != other.dryRun) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false
        if (messageType != other.messageType) return false
        if (signature != null) {
            if (other.signature == null) return false
            if (!signature.contentEquals(other.signature)) return false
        } else if (other.signature != null) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.VerifyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the `MessageType` parameter with a value of `DIGEST`.
         *
         * If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.
         */
        public var message: kotlin.ByteArray? = null
        /**
         * Tells KMS whether the value of the `Message` parameter should be hashed as part of the signing algorithm. Use `RAW` for unhashed messages; use `DIGEST` for message digests, which are already hashed.
         *
         * When the value of `MessageType` is `RAW`, KMS uses the standard signing algorithm, which begins with a hash function. When the value is `DIGEST`, KMS skips the hashing step in the signing algorithm.
         *
         * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with an unhashed message, the security of the verification operation can be compromised.
         *
         * When the value of `MessageType`is `DIGEST`, the length of the `Message` value must match the length of hashed messages for the specified signing algorithm.
         *
         * You can submit a message digest and omit the `MessageType` or specify `RAW` so the digest is hashed again while signing. However, if the signed message is hashed once while signing, but twice while verifying, verification fails, even when the message hasn't changed.
         *
         * The hashing algorithm in that `Verify` uses is based on the `SigningAlgorithm` value.
         * + Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.
         * + Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.
         * + Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.
         * + SM2DSA uses the SM3 hashing algorithm. For details, see [Offline verification with SM2 key pairs](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
         */
        public var messageType: aws.sdk.kotlin.services.kms.model.MessageType? = null
        /**
         * The signature that the `Sign` operation generated.
         */
        public var signature: kotlin.ByteArray? = null
        /**
         * The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.VerifyRequest) : this() {
            this.dryRun = x.dryRun
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.message = x.message
            this.messageType = x.messageType
            this.signature = x.signature
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.VerifyRequest = VerifyRequest(this)
    }
}
