// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * Identifies a customer managed key in the account and Region.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * One or more tags. Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("keyId=$keyId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (keyId != other.keyId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.TagResourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies a customer managed key in the account and Region.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * One or more tags. Each tag consists of a tag key and a tag value. The tag value can be an empty (null) string.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.TagResourceRequest) : this() {
            this.keyId = x.keyId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.TagResourceRequest = TagResourceRequest(this)
    }
}
