// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class SignRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The `KeyUsage` type of the KMS key must be `SIGN_VERIFY`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide a message digest.
     *
     * If you provide a message digest, use the `DIGEST` value of `MessageType` to prevent the digest from being hashed again while signing.
     */
    public val message: kotlin.ByteArray? = builder.message
    /**
     * Tells KMS whether the value of the `Message` parameter should be hashed as part of the signing algorithm. Use `RAW` for unhashed messages; use `DIGEST` for message digests, which are already hashed.
     *
     * When the value of `MessageType` is `RAW`, KMS uses the standard signing algorithm, which begins with a hash function. When the value is `DIGEST`, KMS skips the hashing step in the signing algorithm.
     *
     * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with an unhashed message, the security of the signing operation can be compromised.
     *
     * When the value of `MessageType`is `DIGEST`, the length of the `Message` value must match the length of hashed messages for the specified signing algorithm.
     *
     * You can submit a message digest and omit the `MessageType` or specify `RAW` so the digest is hashed again while signing. However, this can cause verification failures when verifying with a system that assumes a single hash.
     *
     * The hashing algorithm in that `Sign` uses is based on the `SigningAlgorithm` value.
     * + Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.
     * + Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.
     * + Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.
     * + SM2DSA uses the SM3 hashing algorithm. For details, see [Offline verification with SM2 key pairs](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
     */
    public val messageType: aws.sdk.kotlin.services.kms.model.MessageType? = builder.messageType
    /**
     * Specifies the signing algorithm to use when signing the message.
     *
     * Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key. When signing with RSA key pairs, RSASSA-PSS algorithms are preferred. We include RSASSA-PKCS1-v1_5 algorithms for compatibility with existing applications.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.SignRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignRequest(")
        append("dryRun=$dryRun,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageType=$messageType,")
        append("signingAlgorithm=$signingAlgorithm")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignRequest

        if (dryRun != other.dryRun) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false
        if (messageType != other.messageType) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.SignRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The `KeyUsage` type of the KMS key must be `SIGN_VERIFY`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide a message digest.
         *
         * If you provide a message digest, use the `DIGEST` value of `MessageType` to prevent the digest from being hashed again while signing.
         */
        public var message: kotlin.ByteArray? = null
        /**
         * Tells KMS whether the value of the `Message` parameter should be hashed as part of the signing algorithm. Use `RAW` for unhashed messages; use `DIGEST` for message digests, which are already hashed.
         *
         * When the value of `MessageType` is `RAW`, KMS uses the standard signing algorithm, which begins with a hash function. When the value is `DIGEST`, KMS skips the hashing step in the signing algorithm.
         *
         * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with an unhashed message, the security of the signing operation can be compromised.
         *
         * When the value of `MessageType`is `DIGEST`, the length of the `Message` value must match the length of hashed messages for the specified signing algorithm.
         *
         * You can submit a message digest and omit the `MessageType` or specify `RAW` so the digest is hashed again while signing. However, this can cause verification failures when verifying with a system that assumes a single hash.
         *
         * The hashing algorithm in that `Sign` uses is based on the `SigningAlgorithm` value.
         * + Signing algorithms that end in SHA_256 use the SHA_256 hashing algorithm.
         * + Signing algorithms that end in SHA_384 use the SHA_384 hashing algorithm.
         * + Signing algorithms that end in SHA_512 use the SHA_512 hashing algorithm.
         * + SM2DSA uses the SM3 hashing algorithm. For details, see [Offline verification with SM2 key pairs](https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-sm-offline-verification).
         */
        public var messageType: aws.sdk.kotlin.services.kms.model.MessageType? = null
        /**
         * Specifies the signing algorithm to use when signing the message.
         *
         * Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key. When signing with RSA key pairs, RSASSA-PSS algorithms are preferred. We include RSASSA-PKCS1-v1_5 algorithms for compatibility with existing applications.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.SignRequest) : this() {
            this.dryRun = x.dryRun
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.message = x.message
            this.messageType = x.messageType
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.SignRequest = SignRequest(this)
    }
}
