// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class RetireGrantRequest private constructor(builder: Builder) {
    /**
     * Checks if your request will succeed. `DryRun` is an optional parameter.
     *
     * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Identifies the grant to retire. To get the grant ID, use CreateGrant, ListGrants, or ListRetirableGrants.
     * + Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
     */
    public val grantId: kotlin.String? = builder.grantId
    /**
     * Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.
     *
     * Only the CreateGrant operation returns a grant token. For details, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Eventual consistency](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency) in the *Key Management Service Developer Guide*.
     */
    public val grantToken: kotlin.String? = builder.grantToken
    /**
     * The key ARN KMS key associated with the grant. To find the key ARN, use the ListKeys operation.
     *
     * For example: `arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     */
    public val keyId: kotlin.String? = builder.keyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.RetireGrantRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetireGrantRequest(")
        append("dryRun=$dryRun,")
        append("grantId=$grantId,")
        append("grantToken=$grantToken,")
        append("keyId=$keyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (grantId?.hashCode() ?: 0)
        result = 31 * result + (grantToken?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetireGrantRequest

        if (dryRun != other.dryRun) return false
        if (grantId != other.grantId) return false
        if (grantToken != other.grantToken) return false
        if (keyId != other.keyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.RetireGrantRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Checks if your request will succeed. `DryRun` is an optional parameter.
         *
         * To learn more about how to use this parameter, see [Testing your KMS API calls](https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html) in the *Key Management Service Developer Guide*.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * Identifies the grant to retire. To get the grant ID, use CreateGrant, ListGrants, or ListRetirableGrants.
         * + Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
         */
        public var grantId: kotlin.String? = null
        /**
         * Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.
         *
         * Only the CreateGrant operation returns a grant token. For details, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Eventual consistency](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency) in the *Key Management Service Developer Guide*.
         */
        public var grantToken: kotlin.String? = null
        /**
         * The key ARN KMS key associated with the grant. To find the key ARN, use the ListKeys operation.
         *
         * For example: `arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         */
        public var keyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.RetireGrantRequest) : this() {
            this.dryRun = x.dryRun
            this.grantId = x.grantId
            this.grantToken = x.grantToken
            this.keyId = x.keyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.RetireGrantRequest = RetireGrantRequest(this)
    }
}
