// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ListGrantsRequest private constructor(builder: Builder) {
    /**
     * Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant.
     */
    public val grantId: kotlin.String? = builder.grantId
    /**
     * Returns only grants where the specified principal is the grantee principal for the grant.
     */
    public val granteePrincipal: kotlin.String? = builder.granteePrincipal
    /**
     * Returns only grants for the specified KMS key. This parameter is required.
     *
     * Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.
     *
     * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of `NextMarker` from the truncated response you just received.
     */
    public val marker: kotlin.String? = builder.marker

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ListGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGrantsRequest(")
        append("grantId=$grantId,")
        append("granteePrincipal=$granteePrincipal,")
        append("keyId=$keyId,")
        append("limit=$limit,")
        append("marker=$marker")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantId?.hashCode() ?: 0
        result = 31 * result + (granteePrincipal?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGrantsRequest

        if (grantId != other.grantId) return false
        if (granteePrincipal != other.granteePrincipal) return false
        if (keyId != other.keyId) return false
        if (limit != other.limit) return false
        if (marker != other.marker) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ListGrantsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Returns only the grant with the specified grant ID. The grant ID uniquely identifies the grant.
         */
        public var grantId: kotlin.String? = null
        /**
         * Returns only grants where the specified principal is the grantee principal for the grant.
         */
        public var granteePrincipal: kotlin.String? = null
        /**
         * Returns only grants for the specified KMS key. This parameter is required.
         *
         * Specify the key ID or key ARN of the KMS key. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.
         *
         * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.
         */
        public var limit: kotlin.Int? = null
        /**
         * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of `NextMarker` from the truncated response you just received.
         */
        public var marker: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ListGrantsRequest) : this() {
            this.grantId = x.grantId
            this.granteePrincipal = x.granteePrincipal
            this.keyId = x.keyId
            this.limit = x.limit
            this.marker = x.marker
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ListGrantsRequest = ListGrantsRequest(this)
    }
}
