// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a KMS key.
 *
 * This data type is used as a response element for the CreateKey, DescribeKey, and ReplicateKey operations.
 */
public class KeyMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the KMS key. For examples, see [Key Management Service (KMS)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms) in the Example ARNs section of the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in an CloudHSM [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html), KMS creates the key material for the KMS key in the associated CloudHSM cluster. This field is present only when the KMS key is created in an CloudHSM key store.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * The date and time when the KMS key was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A unique identifier for the [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) that contains the KMS key. This field is present only when the KMS key is created in a custom key store.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * Instead, use the `KeySpec` field.
     *
     * The `KeySpec` and `CustomerMasterKeySpec` fields have the same value. We recommend that you use the `KeySpec` field in your code. However, to avoid breaking changes, KMS supports both fields.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = builder.customerMasterKeySpec
    /**
     * The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its `KeyState` is `PendingDeletion`.
     *
     * When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is `PendingReplicaDeletion` and the length of its waiting period is displayed in the `PendingDeletionWindowInDays` field.
     */
    public val deletionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.deletionDate
    /**
     * The description of the KMS key.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether the KMS key is enabled. When `KeyState` is `Enabled` this value is true, otherwise it is false.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.
     *
     * This value is present only when the `KeyUsage` of the KMS key is `ENCRYPT_DECRYPT`.
     */
    public val encryptionAlgorithms: List<EncryptionAlgorithmSpec>? = builder.encryptionAlgorithms
    /**
     * Specifies whether the KMS key's key material expires. This value is present only when `Origin` is `EXTERNAL`, otherwise this value is omitted.
     */
    public val expirationModel: aws.sdk.kotlin.services.kms.model.ExpirationModelType? = builder.expirationModel
    /**
     * The globally unique identifier for the KMS key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see [KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in the *Key Management Service Developer Guide*.
     */
    public val keyManager: aws.sdk.kotlin.services.kms.model.KeyManagerType? = builder.keyManager
    /**
     * Describes the type of key material in the KMS key.
     */
    public val keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = builder.keySpec
    /**
     * The current status of the KMS key.
     *
     * For more information about how key state affects the use of a KMS key, see [Key states of KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html) in the *Key Management Service Developer Guide*.
     */
    public val keyState: aws.sdk.kotlin.services.kms.model.KeyState? = builder.keyState
    /**
     * The [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key.
     */
    public val keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = builder.keyUsage
    /**
     * The message authentication code (MAC) algorithm that the HMAC KMS key supports.
     *
     * This value is present only when the `KeyUsage` of the KMS key is `GENERATE_VERIFY_MAC`.
     */
    public val macAlgorithms: List<MacAlgorithmSpec>? = builder.macAlgorithms
    /**
     * Indicates whether the KMS key is a multi-Region (`True`) or regional (`False`) key. This value is `True` for multi-Region primary and replica keys and `False` for regional KMS keys.
     *
     * For more information about multi-Region keys, see [Multi-Region keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
     */
    public val multiRegion: kotlin.Boolean? = builder.multiRegion
    /**
     * Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the `MultiRegion` field is `True`.
     *
     * For more information about any listed KMS key, use the DescribeKey operation.
     * + `MultiRegionKeyType` indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
     * + `PrimaryKey` displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.
     * + `ReplicaKeys` displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.
     */
    public val multiRegionConfiguration: aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration? = builder.multiRegionConfiguration
    /**
     * The source of the key material for the KMS key. When this value is `AWS_KMS`, KMS created the key material. When this value is `EXTERNAL`, the key material was imported or the KMS key doesn't have any key material. When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
     */
    public val origin: aws.sdk.kotlin.services.kms.model.OriginType? = builder.origin
    /**
     * The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the `KeyState` of the KMS key is `PendingReplicaDeletion`. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.
     *
     * When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the `DeletionDate` field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the `KeyState` of the scheduled primary key changes from `PendingReplicaDeletion` to `PendingDeletion` and the deletion date appears in the `DeletionDate` field.
     */
    public val pendingDeletionWindowInDays: kotlin.Int? = builder.pendingDeletionWindowInDays
    /**
     * The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.
     *
     * This field appears only when the `KeyUsage` of the KMS key is `SIGN_VERIFY`.
     */
    public val signingAlgorithms: List<SigningAlgorithmSpec>? = builder.signingAlgorithms
    /**
     * The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose `Origin` is `EXTERNAL` and whose `ExpirationModel` is `KEY_MATERIAL_EXPIRES`, otherwise this value is omitted.
     */
    public val validTo: aws.smithy.kotlin.runtime.time.Instant? = builder.validTo
    /**
     * Information about the external key that is associated with a KMS key in an external key store.
     *
     * For more information, see [External key](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key) in the *Key Management Service Developer Guide*.
     */
    public val xksKeyConfiguration: aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType? = builder.xksKeyConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.KeyMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyMetadata(")
        append("arn=$arn,")
        append("awsAccountId=$awsAccountId,")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("creationDate=$creationDate,")
        append("customKeyStoreId=$customKeyStoreId,")
        append("customerMasterKeySpec=$customerMasterKeySpec,")
        append("deletionDate=$deletionDate,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("encryptionAlgorithms=$encryptionAlgorithms,")
        append("expirationModel=$expirationModel,")
        append("keyId=$keyId,")
        append("keyManager=$keyManager,")
        append("keySpec=$keySpec,")
        append("keyState=$keyState,")
        append("keyUsage=$keyUsage,")
        append("macAlgorithms=$macAlgorithms,")
        append("multiRegion=$multiRegion,")
        append("multiRegionConfiguration=$multiRegionConfiguration,")
        append("origin=$origin,")
        append("pendingDeletionWindowInDays=$pendingDeletionWindowInDays,")
        append("signingAlgorithms=$signingAlgorithms,")
        append("validTo=$validTo,")
        append("xksKeyConfiguration=$xksKeyConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (cloudHsmClusterId?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customKeyStoreId?.hashCode() ?: 0)
        result = 31 * result + (customerMasterKeySpec?.hashCode() ?: 0)
        result = 31 * result + (deletionDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (encryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (expirationModel?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyManager?.hashCode() ?: 0)
        result = 31 * result + (keySpec?.hashCode() ?: 0)
        result = 31 * result + (keyState?.hashCode() ?: 0)
        result = 31 * result + (keyUsage?.hashCode() ?: 0)
        result = 31 * result + (macAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (multiRegion?.hashCode() ?: 0)
        result = 31 * result + (multiRegionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (pendingDeletionWindowInDays ?: 0)
        result = 31 * result + (signingAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (validTo?.hashCode() ?: 0)
        result = 31 * result + (xksKeyConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyMetadata

        if (arn != other.arn) return false
        if (awsAccountId != other.awsAccountId) return false
        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (creationDate != other.creationDate) return false
        if (customKeyStoreId != other.customKeyStoreId) return false
        if (customerMasterKeySpec != other.customerMasterKeySpec) return false
        if (deletionDate != other.deletionDate) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (encryptionAlgorithms != other.encryptionAlgorithms) return false
        if (expirationModel != other.expirationModel) return false
        if (keyId != other.keyId) return false
        if (keyManager != other.keyManager) return false
        if (keySpec != other.keySpec) return false
        if (keyState != other.keyState) return false
        if (keyUsage != other.keyUsage) return false
        if (macAlgorithms != other.macAlgorithms) return false
        if (multiRegion != other.multiRegion) return false
        if (multiRegionConfiguration != other.multiRegionConfiguration) return false
        if (origin != other.origin) return false
        if (pendingDeletionWindowInDays != other.pendingDeletionWindowInDays) return false
        if (signingAlgorithms != other.signingAlgorithms) return false
        if (validTo != other.validTo) return false
        if (xksKeyConfiguration != other.xksKeyConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.KeyMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the KMS key. For examples, see [Key Management Service (KMS)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms) in the Example ARNs section of the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The cluster ID of the CloudHSM cluster that contains the key material for the KMS key. When you create a KMS key in an CloudHSM [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html), KMS creates the key material for the KMS key in the associated CloudHSM cluster. This field is present only when the KMS key is created in an CloudHSM key store.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * The date and time when the KMS key was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) that contains the KMS key. This field is present only when the KMS key is created in a custom key store.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * Instead, use the `KeySpec` field.
         *
         * The `KeySpec` and `CustomerMasterKeySpec` fields have the same value. We recommend that you use the `KeySpec` field in your code. However, to avoid breaking changes, KMS supports both fields.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = null
        /**
         * The date and time after which KMS deletes this KMS key. This value is present only when the KMS key is scheduled for deletion, that is, when its `KeyState` is `PendingDeletion`.
         *
         * When the primary key in a multi-Region key is scheduled for deletion but still has replica keys, its key state is `PendingReplicaDeletion` and the length of its waiting period is displayed in the `PendingDeletionWindowInDays` field.
         */
        public var deletionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the KMS key.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether the KMS key is enabled. When `KeyState` is `Enabled` this value is true, otherwise it is false.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The encryption algorithms that the KMS key supports. You cannot use the KMS key with other encryption algorithms within KMS.
         *
         * This value is present only when the `KeyUsage` of the KMS key is `ENCRYPT_DECRYPT`.
         */
        public var encryptionAlgorithms: List<EncryptionAlgorithmSpec>? = null
        /**
         * Specifies whether the KMS key's key material expires. This value is present only when `Origin` is `EXTERNAL`, otherwise this value is omitted.
         */
        public var expirationModel: aws.sdk.kotlin.services.kms.model.ExpirationModelType? = null
        /**
         * The globally unique identifier for the KMS key.
         */
        public var keyId: kotlin.String? = null
        /**
         * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed. For more information about the difference, see [KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in the *Key Management Service Developer Guide*.
         */
        public var keyManager: aws.sdk.kotlin.services.kms.model.KeyManagerType? = null
        /**
         * Describes the type of key material in the KMS key.
         */
        public var keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = null
        /**
         * The current status of the KMS key.
         *
         * For more information about how key state affects the use of a KMS key, see [Key states of KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html) in the *Key Management Service Developer Guide*.
         */
        public var keyState: aws.sdk.kotlin.services.kms.model.KeyState? = null
        /**
         * The [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) for which you can use the KMS key.
         */
        public var keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = null
        /**
         * The message authentication code (MAC) algorithm that the HMAC KMS key supports.
         *
         * This value is present only when the `KeyUsage` of the KMS key is `GENERATE_VERIFY_MAC`.
         */
        public var macAlgorithms: List<MacAlgorithmSpec>? = null
        /**
         * Indicates whether the KMS key is a multi-Region (`True`) or regional (`False`) key. This value is `True` for multi-Region primary and replica keys and `False` for regional KMS keys.
         *
         * For more information about multi-Region keys, see [Multi-Region keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *Key Management Service Developer Guide*.
         */
        public var multiRegion: kotlin.Boolean? = null
        /**
         * Lists the primary and replica keys in same multi-Region key. This field is present only when the value of the `MultiRegion` field is `True`.
         *
         * For more information about any listed KMS key, use the DescribeKey operation.
         * + `MultiRegionKeyType` indicates whether the KMS key is a `PRIMARY` or `REPLICA` key.
         * + `PrimaryKey` displays the key ARN and Region of the primary key. This field displays the current KMS key if it is the primary key.
         * + `ReplicaKeys` displays the key ARNs and Regions of all replica keys. This field includes the current KMS key if it is a replica key.
         */
        public var multiRegionConfiguration: aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration? = null
        /**
         * The source of the key material for the KMS key. When this value is `AWS_KMS`, KMS created the key material. When this value is `EXTERNAL`, the key material was imported or the KMS key doesn't have any key material. When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
         */
        public var origin: aws.sdk.kotlin.services.kms.model.OriginType? = null
        /**
         * The waiting period before the primary key in a multi-Region key is deleted. This waiting period begins when the last of its replica keys is deleted. This value is present only when the `KeyState` of the KMS key is `PendingReplicaDeletion`. That indicates that the KMS key is the primary key in a multi-Region key, it is scheduled for deletion, and it still has existing replica keys.
         *
         * When a single-Region KMS key or a multi-Region replica key is scheduled for deletion, its deletion date is displayed in the `DeletionDate` field. However, when the primary key in a multi-Region key is scheduled for deletion, its waiting period doesn't begin until all of its replica keys are deleted. This value displays that waiting period. When the last replica key in the multi-Region key is deleted, the `KeyState` of the scheduled primary key changes from `PendingReplicaDeletion` to `PendingDeletion` and the deletion date appears in the `DeletionDate` field.
         */
        public var pendingDeletionWindowInDays: kotlin.Int? = null
        /**
         * The signing algorithms that the KMS key supports. You cannot use the KMS key with other signing algorithms within KMS.
         *
         * This field appears only when the `KeyUsage` of the KMS key is `SIGN_VERIFY`.
         */
        public var signingAlgorithms: List<SigningAlgorithmSpec>? = null
        /**
         * The time at which the imported key material expires. When the key material expires, KMS deletes the key material and the KMS key becomes unusable. This value is present only for KMS keys whose `Origin` is `EXTERNAL` and whose `ExpirationModel` is `KEY_MATERIAL_EXPIRES`, otherwise this value is omitted.
         */
        public var validTo: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the external key that is associated with a KMS key in an external key store.
         *
         * For more information, see [External key](https://docs.aws.amazon.com/kms/latest/developerguide/keystore-external.html#concept-external-key) in the *Key Management Service Developer Guide*.
         */
        public var xksKeyConfiguration: aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.KeyMetadata) : this() {
            this.arn = x.arn
            this.awsAccountId = x.awsAccountId
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.creationDate = x.creationDate
            this.customKeyStoreId = x.customKeyStoreId
            this.customerMasterKeySpec = x.customerMasterKeySpec
            this.deletionDate = x.deletionDate
            this.description = x.description
            this.enabled = x.enabled
            this.encryptionAlgorithms = x.encryptionAlgorithms
            this.expirationModel = x.expirationModel
            this.keyId = x.keyId
            this.keyManager = x.keyManager
            this.keySpec = x.keySpec
            this.keyState = x.keyState
            this.keyUsage = x.keyUsage
            this.macAlgorithms = x.macAlgorithms
            this.multiRegion = x.multiRegion
            this.multiRegionConfiguration = x.multiRegionConfiguration
            this.origin = x.origin
            this.pendingDeletionWindowInDays = x.pendingDeletionWindowInDays
            this.signingAlgorithms = x.signingAlgorithms
            this.validTo = x.validTo
            this.xksKeyConfiguration = x.xksKeyConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.KeyMetadata = KeyMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration] inside the given [block]
         */
        public fun multiRegionConfiguration(block: aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration.Builder.() -> kotlin.Unit) {
            this.multiRegionConfiguration = aws.sdk.kotlin.services.kms.model.MultiRegionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType] inside the given [block]
         */
        public fun xksKeyConfiguration(block: aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType.Builder.() -> kotlin.Unit) {
            this.xksKeyConfiguration = aws.sdk.kotlin.services.kms.model.XksKeyConfigurationType.invoke(block)
        }
    }
}
