// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GenerateRandomRequest private constructor(builder: Builder) {
    /**
     * Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
     *
     * External key store IDs are not valid for this parameter. If you specify the ID of an external key store, `GenerateRandom` throws an `UnsupportedOperationException`.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * The length of the random byte string. This parameter is required.
     */
    public val numberOfBytes: kotlin.Int? = builder.numberOfBytes
    /**
     * A signed [attestation document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
     *
     * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
     *
     * When you use this parameter, instead of returning plaintext bytes, KMS encrypts the plaintext bytes under the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `Plaintext` field in the response is null or empty.
     *
     * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
     */
    public val recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = builder.recipient

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GenerateRandomRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateRandomRequest(")
        append("customKeyStoreId=$customKeyStoreId,")
        append("numberOfBytes=$numberOfBytes,")
        append("recipient=$recipient")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customKeyStoreId?.hashCode() ?: 0
        result = 31 * result + (numberOfBytes ?: 0)
        result = 31 * result + (recipient?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateRandomRequest

        if (customKeyStoreId != other.customKeyStoreId) return false
        if (numberOfBytes != other.numberOfBytes) return false
        if (recipient != other.recipient) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GenerateRandomRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Generates the random byte string in the CloudHSM cluster that is associated with the specified CloudHSM key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
         *
         * External key store IDs are not valid for this parameter. If you specify the ID of an external key store, `GenerateRandom` throws an `UnsupportedOperationException`.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * The length of the random byte string. This parameter is required.
         */
        public var numberOfBytes: kotlin.Int? = null
        /**
         * A signed [attestation document](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitro-enclave-how.html#term-attestdoc) from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is `RSAES_OAEP_SHA_256`.
         *
         * This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the [Amazon Web Services Nitro Enclaves SDK](https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk) or any Amazon Web Services SDK.
         *
         * When you use this parameter, instead of returning plaintext bytes, KMS encrypts the plaintext bytes under the public key in the attestation document, and returns the resulting ciphertext in the `CiphertextForRecipient` field in the response. This ciphertext can be decrypted only with the private key in the enclave. The `Plaintext` field in the response is null or empty.
         *
         * For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see [How Amazon Web Services Nitro Enclaves uses KMS](https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html) in the *Key Management Service Developer Guide*.
         */
        public var recipient: aws.sdk.kotlin.services.kms.model.RecipientInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GenerateRandomRequest) : this() {
            this.customKeyStoreId = x.customKeyStoreId
            this.numberOfBytes = x.numberOfBytes
            this.recipient = x.recipient
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GenerateRandomRequest = GenerateRandomRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.RecipientInfo] inside the given [block]
         */
        public fun recipient(block: aws.sdk.kotlin.services.kms.model.RecipientInfo.Builder.() -> kotlin.Unit) {
            this.recipient = aws.sdk.kotlin.services.kms.model.RecipientInfo.invoke(block)
        }
    }
}
