// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class EncryptResponse private constructor(builder: Builder) {
    /**
     * The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val ciphertextBlob: kotlin.ByteArray? = builder.ciphertextBlob
    /**
     * The encryption algorithm that was used to encrypt the plaintext.
     */
    public val encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.encryptionAlgorithm
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to encrypt the plaintext.
     */
    public val keyId: kotlin.String? = builder.keyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.EncryptResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptResponse(")
        append("ciphertextBlob=$ciphertextBlob,")
        append("encryptionAlgorithm=$encryptionAlgorithm,")
        append("keyId=$keyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertextBlob?.contentHashCode() ?: 0
        result = 31 * result + (encryptionAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptResponse

        if (ciphertextBlob != null) {
            if (other.ciphertextBlob == null) return false
            if (!ciphertextBlob.contentEquals(other.ciphertextBlob)) return false
        } else if (other.ciphertextBlob != null) return false
        if (encryptionAlgorithm != other.encryptionAlgorithm) return false
        if (keyId != other.keyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.EncryptResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encrypted plaintext. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var ciphertextBlob: kotlin.ByteArray? = null
        /**
         * The encryption algorithm that was used to encrypt the plaintext.
         */
        public var encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to encrypt the plaintext.
         */
        public var keyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.EncryptResponse) : this() {
            this.ciphertextBlob = x.ciphertextBlob
            this.encryptionAlgorithm = x.encryptionAlgorithm
            this.keyId = x.keyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.EncryptResponse = EncryptResponse(this)
    }
}
