// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class CreateAliasRequest private constructor(builder: Builder) {
    /**
     * Specifies the alias name. This value must begin with `alias/` followed by a name, such as `alias/ExampleAlias`.
     *
     * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
     *
     * The `AliasName` value must be string of 1-256 characters. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). The alias name cannot begin with `alias/aws/`. The `alias/aws/` prefix is reserved for [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
     */
    public val aliasName: kotlin.String? = builder.aliasName
    /**
     * Associates the alias with the specified [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk). The KMS key must be in the same Amazon Web Services Region.
     *
     * A valid key ID is required. If you supply a null or empty string value, this operation returns an error.
     *
     * For help finding the key ID and ARN, see [Finding the Key ID and ARN](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn) in the **Key Management Service Developer Guide**.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val targetKeyId: kotlin.String? = builder.targetKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.CreateAliasRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAliasRequest(")
        append("aliasName=$aliasName,")
        append("targetKeyId=$targetKeyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasName?.hashCode() ?: 0
        result = 31 * result + (targetKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAliasRequest

        if (aliasName != other.aliasName) return false
        if (targetKeyId != other.targetKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.CreateAliasRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the alias name. This value must begin with `alias/` followed by a name, such as `alias/ExampleAlias`.
         *
         * Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.
         *
         * The `AliasName` value must be string of 1-256 characters. It can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). The alias name cannot begin with `alias/aws/`. The `alias/aws/` prefix is reserved for [Amazon Web Services managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
         */
        public var aliasName: kotlin.String? = null
        /**
         * Associates the alias with the specified [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk). The KMS key must be in the same Amazon Web Services Region.
         *
         * A valid key ID is required. If you supply a null or empty string value, this operation returns an error.
         *
         * For help finding the key ID and ARN, see [Finding the Key ID and ARN](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn) in the **Key Management Service Developer Guide**.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var targetKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.CreateAliasRequest) : this() {
            this.aliasName = x.aliasName
            this.targetKeyId = x.targetKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.CreateAliasRequest = CreateAliasRequest(this)
    }
}
