// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideowebrtcstorage.serde

import aws.sdk.kotlin.services.kinesisvideowebrtcstorage.model.JoinStorageSessionResponse
import aws.sdk.kotlin.services.kinesisvideowebrtcstorage.model.KinesisVideoWebRtcStorageException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class JoinStorageSessionOperationDeserializer: HttpDeserializer.NonStreaming<JoinStorageSessionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): JoinStorageSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwJoinStorageSessionError(context, call, payload)
        }
        val builder = JoinStorageSessionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwJoinStorageSessionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoWebRtcStorageException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KinesisVideoWebRtcStorageException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
