// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideosignaling.serde

import aws.sdk.kotlin.services.kinesisvideosignaling.model.GetIceServerConfigResponse
import aws.sdk.kotlin.services.kinesisvideosignaling.model.IceServer
import aws.sdk.kotlin.services.kinesisvideosignaling.model.KinesisVideoSignalingException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetIceServerConfigOperationDeserializer: HttpDeserialize<GetIceServerConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetIceServerConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIceServerConfigError(context, call)
        }
        val builder = GetIceServerConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetIceServerConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetIceServerConfigError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoSignalingException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "SessionExpiredException" -> SessionExpiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientException" -> InvalidClientExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisVideoSignalingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIceServerConfigOperationBody(builder: GetIceServerConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ICESERVERLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("IceServerList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ICESERVERLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ICESERVERLIST_DESCRIPTOR.index -> builder.iceServerList =
                    deserializer.deserializeList(ICESERVERLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<IceServer>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIceServerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
