// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideomedia.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Identifies the chunk on the Kinesis video stream where you want the `GetMedia` API to start returning media data. You have the following options to identify the starting chunk:
 * + Choose the latest (or oldest) chunk.
 * + Identify a specific chunk. You can identify a specific chunk either by providing a fragment number or timestamp (server or producer).
 * + Each chunk's metadata includes a continuation token as a Matroska (MKV) tag (`AWS_KINESISVIDEO_CONTINUATION_TOKEN`). If your previous `GetMedia` request terminated, you can use this tag value in your next `GetMedia` request. The API then starts returning chunks starting where the last API ended.
 */
class StartSelector private constructor(builder: Builder) {
    /**
     * Specifies the fragment number from where you want the `GetMedia` API to start returning the fragments.
     */
    val afterFragmentNumber: kotlin.String? = builder.afterFragmentNumber
    /**
     * Continuation token that Kinesis Video Streams returned in the previous `GetMedia` response. The `GetMedia` API then starts with the chunk identified by the continuation token.
     */
    val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
     * + NOW - Start with the latest chunk on the stream.
     * + EARLIEST - Start with earliest available chunk on the stream.
     * + FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the `AfterFragmentNumber` parameter.
     * + PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified producer or server timestamp. You specify the timestamp by adding `StartTimestamp`.
     * +  CONTINUATION_TOKEN - Read using the specified continuation token.
     *
     * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the `startSelectorType`, you don't provide any additional information in the `startSelector`.
     */
    val startSelectorType: aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelectorType? = builder.startSelectorType
    /**
     * A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP as the `startSelectorType`. The `GetMedia` API then starts with the chunk containing the fragment that has the specified timestamp.
     */
    val startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.startTimestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSelector(")
        append("afterFragmentNumber=$afterFragmentNumber,")
        append("continuationToken=$continuationToken,")
        append("startSelectorType=$startSelectorType,")
        append("startTimestamp=$startTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = afterFragmentNumber?.hashCode() ?: 0
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (startSelectorType?.hashCode() ?: 0)
        result = 31 * result + (startTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSelector

        if (afterFragmentNumber != other.afterFragmentNumber) return false
        if (continuationToken != other.continuationToken) return false
        if (startSelectorType != other.startSelectorType) return false
        if (startTimestamp != other.startTimestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelector = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the fragment number from where you want the `GetMedia` API to start returning the fragments.
         */
        var afterFragmentNumber: kotlin.String? = null
        /**
         * Continuation token that Kinesis Video Streams returned in the previous `GetMedia` response. The `GetMedia` API then starts with the chunk identified by the continuation token.
         */
        var continuationToken: kotlin.String? = null
        /**
         * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
         * + NOW - Start with the latest chunk on the stream.
         * + EARLIEST - Start with earliest available chunk on the stream.
         * + FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the `AfterFragmentNumber` parameter.
         * + PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified producer or server timestamp. You specify the timestamp by adding `StartTimestamp`.
         * +  CONTINUATION_TOKEN - Read using the specified continuation token.
         *
         * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the `startSelectorType`, you don't provide any additional information in the `startSelector`.
         */
        var startSelectorType: aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelectorType? = null
        /**
         * A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP as the `startSelectorType`. The `GetMedia` API then starts with the chunk containing the fragment that has the specified timestamp.
         */
        var startTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelector) : this() {
            this.afterFragmentNumber = x.afterFragmentNumber
            this.continuationToken = x.continuationToken
            this.startSelectorType = x.startSelectorType
            this.startTimestamp = x.startTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideomedia.model.StartSelector = StartSelector(this)
    }
}
