// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideomedia.model

import aws.smithy.kotlin.runtime.content.ByteStream

class GetMediaResponse private constructor(builder: Builder) {
    /**
     * The content type of the requested media.
     */
    val contentType: kotlin.String? = builder.contentType
    /**
     * The payload Kinesis Video Streams returns is a sequence of chunks from the specified stream. For information about the chunks, see . The chunks that Kinesis Video Streams returns in the `GetMedia` call also include the following additional Matroska (MKV) tags:
     * + AWS_KINESISVIDEO_CONTINUATION_TOKEN (UTF-8 string) - In the event your `GetMedia` call terminates, you can use this continuation token in your next request to get the next chunk where the last request terminated.
     * + AWS_KINESISVIDEO_MILLIS_BEHIND_NOW (UTF-8 string) - Client applications can use this tag value to determine how far behind the chunk returned in the response is from the latest chunk on the stream.
     * + AWS_KINESISVIDEO_FRAGMENT_NUMBER - Fragment number returned in the chunk.
     * + AWS_KINESISVIDEO_SERVER_TIMESTAMP - Server timestamp of the fragment.
     * + AWS_KINESISVIDEO_PRODUCER_TIMESTAMP - Producer timestamp of the fragment.
     *
     * The following tags will be present if an error occurs:
     * + AWS_KINESISVIDEO_ERROR_CODE - String description of an error that caused GetMedia to stop.
     * + AWS_KINESISVIDEO_ERROR_ID: Integer code of the error.
     *
     * The error codes are as follows:
     * + 3002 - Error writing to the stream
     * + 4000 - Requested fragment is not found
     * + 4500 - Access denied for the stream's KMS key
     * + 4501 - Stream's KMS key is disabled
     * + 4502 - Validation error on the stream's KMS key
     * + 4503 - KMS key specified in the stream is unavailable
     * + 4504 - Invalid usage of the KMS key specified in the stream
     * + 4505 - Invalid state of the KMS key specified in the stream
     * + 4506 - Unable to find the KMS key specified in the stream
     * + 5000 - Internal error
     */
    val payload: aws.smithy.kotlin.runtime.content.ByteStream? = builder.payload

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideomedia.model.GetMediaResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMediaResponse(")
        append("contentType=$contentType,")
        append("payload=$payload)")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentType?.hashCode() ?: 0
        result = 31 * result + (payload?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMediaResponse

        if (contentType != other.contentType) return false
        if (payload != other.payload) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideomedia.model.GetMediaResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The content type of the requested media.
         */
        var contentType: kotlin.String? = null
        /**
         * The payload Kinesis Video Streams returns is a sequence of chunks from the specified stream. For information about the chunks, see . The chunks that Kinesis Video Streams returns in the `GetMedia` call also include the following additional Matroska (MKV) tags:
         * + AWS_KINESISVIDEO_CONTINUATION_TOKEN (UTF-8 string) - In the event your `GetMedia` call terminates, you can use this continuation token in your next request to get the next chunk where the last request terminated.
         * + AWS_KINESISVIDEO_MILLIS_BEHIND_NOW (UTF-8 string) - Client applications can use this tag value to determine how far behind the chunk returned in the response is from the latest chunk on the stream.
         * + AWS_KINESISVIDEO_FRAGMENT_NUMBER - Fragment number returned in the chunk.
         * + AWS_KINESISVIDEO_SERVER_TIMESTAMP - Server timestamp of the fragment.
         * + AWS_KINESISVIDEO_PRODUCER_TIMESTAMP - Producer timestamp of the fragment.
         *
         * The following tags will be present if an error occurs:
         * + AWS_KINESISVIDEO_ERROR_CODE - String description of an error that caused GetMedia to stop.
         * + AWS_KINESISVIDEO_ERROR_ID: Integer code of the error.
         *
         * The error codes are as follows:
         * + 3002 - Error writing to the stream
         * + 4000 - Requested fragment is not found
         * + 4500 - Access denied for the stream's KMS key
         * + 4501 - Stream's KMS key is disabled
         * + 4502 - Validation error on the stream's KMS key
         * + 4503 - KMS key specified in the stream is unavailable
         * + 4504 - Invalid usage of the KMS key specified in the stream
         * + 4505 - Invalid state of the KMS key specified in the stream
         * + 4506 - Unable to find the KMS key specified in the stream
         * + 5000 - Internal error
         */
        var payload: aws.smithy.kotlin.runtime.content.ByteStream? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideomedia.model.GetMediaResponse) : this() {
            this.contentType = x.contentType
            this.payload = x.payload
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideomedia.model.GetMediaResponse = GetMediaResponse(this)
    }
}
