// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.serde

import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetMediaForFragmentListOperationDeserializer: HttpDeserialize<GetMediaForFragmentListResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMediaForFragmentListResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMediaForFragmentListError(context, call)
        }
        val builder = GetMediaForFragmentListResponse.Builder()

        builder.contentType = response.headers["Content-Type"]

        builder.payload = response.body.toByteStream()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMediaForFragmentListError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoArchivedMediaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisVideoArchivedMediaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
