// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a segment of video or other time-delimited data.
 */
public class Fragment private constructor(builder: Builder) {
    /**
     * The playback duration or other time value associated with the fragment.
     */
    public val fragmentLengthInMilliseconds: kotlin.Long = builder.fragmentLengthInMilliseconds
    /**
     * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     */
    public val fragmentNumber: kotlin.String? = builder.fragmentNumber
    /**
     * The total fragment size, including information about the fragment and contained media data.
     */
    public val fragmentSizeInBytes: kotlin.Long = builder.fragmentSizeInBytes
    /**
     * The timestamp from the producer corresponding to the fragment.
     */
    public val producerTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.producerTimestamp
    /**
     * The timestamp from the Amazon Web Services server corresponding to the fragment.
     */
    public val serverTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.serverTimestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Fragment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Fragment(")
        append("fragmentLengthInMilliseconds=$fragmentLengthInMilliseconds,")
        append("fragmentNumber=$fragmentNumber,")
        append("fragmentSizeInBytes=$fragmentSizeInBytes,")
        append("producerTimestamp=$producerTimestamp,")
        append("serverTimestamp=$serverTimestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fragmentLengthInMilliseconds.hashCode()
        result = 31 * result + (fragmentNumber?.hashCode() ?: 0)
        result = 31 * result + (fragmentSizeInBytes.hashCode())
        result = 31 * result + (producerTimestamp?.hashCode() ?: 0)
        result = 31 * result + (serverTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Fragment

        if (fragmentLengthInMilliseconds != other.fragmentLengthInMilliseconds) return false
        if (fragmentNumber != other.fragmentNumber) return false
        if (fragmentSizeInBytes != other.fragmentSizeInBytes) return false
        if (producerTimestamp != other.producerTimestamp) return false
        if (serverTimestamp != other.serverTimestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Fragment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The playback duration or other time value associated with the fragment.
         */
        public var fragmentLengthInMilliseconds: kotlin.Long = 0L
        /**
         * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
         */
        public var fragmentNumber: kotlin.String? = null
        /**
         * The total fragment size, including information about the fragment and contained media data.
         */
        public var fragmentSizeInBytes: kotlin.Long = 0L
        /**
         * The timestamp from the producer corresponding to the fragment.
         */
        public var producerTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp from the Amazon Web Services server corresponding to the fragment.
         */
        public var serverTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Fragment) : this() {
            this.fragmentLengthInMilliseconds = x.fragmentLengthInMilliseconds
            this.fragmentNumber = x.fragmentNumber
            this.fragmentSizeInBytes = x.fragmentSizeInBytes
            this.producerTimestamp = x.producerTimestamp
            this.serverTimestamp = x.serverTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.Fragment = Fragment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
