// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model



/**
 * Describes the timestamp range and timestamp origin of a range of fragments.
 *
 * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a stream of fragments with producer timestamps that are approximately equal to the true clock time, the clip will contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same time range and very different points in time, only the oldest ingested collection of fragments are returned.
 */
public class ClipFragmentSelector private constructor(builder: Builder) {
    /**
     * The origin of the timestamps to use (Server or Producer).
     */
    public val fragmentSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType = requireNotNull(builder.fragmentSelectorType) { "A non-null value must be provided for fragmentSelectorType" }
    /**
     * The range of timestamps to return.
     */
    public val timestampRange: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipTimestampRange? = builder.timestampRange

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClipFragmentSelector(")
        append("fragmentSelectorType=$fragmentSelectorType,")
        append("timestampRange=$timestampRange")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fragmentSelectorType.hashCode()
        result = 31 * result + (timestampRange?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClipFragmentSelector

        if (fragmentSelectorType != other.fragmentSelectorType) return false
        if (timestampRange != other.timestampRange) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The origin of the timestamps to use (Server or Producer).
         */
        public var fragmentSelectorType: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType? = null
        /**
         * The range of timestamps to return.
         */
        public var timestampRange: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipTimestampRange? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector) : this() {
            this.fragmentSelectorType = x.fragmentSelectorType
            this.timestampRange = x.timestampRange
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector = ClipFragmentSelector(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipTimestampRange] inside the given [block]
         */
        public fun timestampRange(block: aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipTimestampRange.Builder.() -> kotlin.Unit) {
            this.timestampRange = aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.ClipTimestampRange.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (fragmentSelectorType == null) fragmentSelectorType = ClipFragmentSelectorType.SdkUnknown("no value provided")
            return this
        }
    }
}
