// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideoarchivedmedia.serde

import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
import aws.sdk.kotlin.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetHLSStreamingSessionURLOperationDeserializer: HttpDeserialize<GetHlsStreamingSessionUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetHlsStreamingSessionUrlResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetHlsStreamingSessionUrlError(context, call)
        }
        val builder = GetHlsStreamingSessionUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetHLSStreamingSessionURLOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetHlsStreamingSessionUrlError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoArchivedMediaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCodecPrivateDataException" -> InvalidCodecPrivateDataExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedStreamMediaTypeException" -> UnsupportedStreamMediaTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        "NoDataRetentionException" -> NoDataRetentionExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingCodecPrivateDataException" -> MissingCodecPrivateDataExceptionDeserializer().deserialize(context, wrappedCall)
        else -> KinesisVideoArchivedMediaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetHLSStreamingSessionURLOperationBody(builder: GetHlsStreamingSessionUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HLSSTREAMINGSESSIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HLSStreamingSessionURL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HLSSTREAMINGSESSIONURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HLSSTREAMINGSESSIONURL_DESCRIPTOR.index -> builder.hlsStreamingSessionUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
